<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Board;

class Labels extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
    }
    public function getLabels()
    {
        try {
            $data = (new \mgCRM2\Repositories\Labels())->getLabelsWithClient();
            return $this->returnData($data);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function removeLabel($id)
    {
        $id = (int) $id;
        try {
            $labelsMap = \mgCRM2\Models\Setting::where("name", "labels_map")->where("admin_id", 0)->first()->value;
            foreach ($labelsMap as $index => $idMap) {
                if($idMap == $id) {
                    unset($labelsMap[$index]);
                }
            }
            if(count($labelsMap) == 0) {
                $labelsMap = "[]";
            } else {
                $labelsMap = json_encode($labelsMap);
            }
            \mgCRM2\Models\Setting::where("name", "labels_map")->where("admin_id", 0)->update(["value" => $labelsMap]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData(["status" => "success", "msg" => "Label has been removed."]);
    }
    public function addLabel($id)
    {
        try {
            $labelsMap = \mgCRM2\Models\Setting::where("name", "labels_map")->where("admin_id", 0)->first()->value;
            if(is_null($labelsMap)) {
                $labelsMap = [(int) $id];
                \mgCRM2\Models\Setting::create(["name" => "labels_map", "admin_id" => 0, "value" => $labelsMap]);
            } else {
                $labelsMap[] = (int) $id;
                $labelsMap = json_encode($labelsMap);
                \mgCRM2\Models\Setting::where("name", "labels_map")->where("admin_id", 0)->update(["value" => $labelsMap]);
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData(["status" => "success", "msg" => "Label has been added."]);
    }
    public function updateOrder()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            (new \mgCRM2\Repositories\Labels())->updateOrder($requestData);
            return $this->returnData([]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>