<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Dashboard;

class DashboardCalendar extends \mgCRM2\Controllers\Source\AbstractController
{
    protected $adminID = false;
    protected $year = false;
    protected $month = false;
    protected $requestData = [];
    public function __construct()
    {
        parent::__construct();
        $this->requestData = json_decode($this->app->request->getBody(), true);
        $this->adminID = array_get($this->requestData, "admin", false);
        $this->year = array_get($this->requestData, "year", false);
        $this->month = array_get($this->requestData, "month", false);
        $this->campaign = array_get($this->requestData, "campaign", false);
    }
    public function getCounters()
    {
        try {
            $repo = new \mgCRM2\Repositories\Followups();
            return $this->returnData($repo->getCountersForCalendar($this->year, $this->month + 1, $this->adminID, $this->campaign));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>