<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Dashboard;

/**
 * Class to maintain actions for single lead instance
 */
class DashboardFollowups extends \mgCRM2\Controllers\Source\AbstractController
{
    protected $adminID = false;
    protected $year = false;
    protected $month = false;
    protected $day = false;
    protected $requestData = [];
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Followups();
        $this->requestData = json_decode($this->app->request->getBody(), true);
        if(empty($this->requestData)) {
            $this->requestData = [];
        }
        $this->adminID = array_get($this->requestData, "admin", false);
        $this->year = array_get($this->requestData, "year", false);
        $this->month = array_get($this->requestData, "month", false);
        $this->day = array_get($this->requestData, "day", false);
    }
    public function getForTable()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            if($this->app->config("isWhmcsAPIcall") === true) {
                array_set($requestData, "params.search.predicateObject.day", array_get($requestData, "date"));
                $adminID = array_get($requestData, "adminID") == NULL ? 0 : array_get($requestData, "adminID");
            } else {
                $adminID = $this->adminID;
            }
            $this->returnData($this->repository->parseForDashboardTable($requestData, $adminID, $this->app->config("isWhmcsAPIcall")));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>