<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Helpers;

/**
 * Class to maintain actions for single lead instance
 */
class SelectInput extends \mgCRM2\Controllers\Source\AbstractController
{
    protected $limit = 10;
    public function findClient($id)
    {
        try {
            $results = \Illuminate\Database\Capsule\Manager::table("tblclients")->find($id);
            $results->name = $results->firstname . " " . $results->lastname;
            unset($results->password);
            unset($results->uuid);
            unset($results->ip);
            foreach ($results as &$result) {
                $result = html_entity_decode($result, ENT_QUOTES);
            }
            $clientCustomFields = \Illuminate\Database\Capsule\Manager::table("tblcustomfields")->join("tblcustomfieldsvalues", "tblcustomfieldsvalues.fieldid", "=", "tblcustomfields.id")->where("tblcustomfields.type", "=", "client")->where("tblcustomfieldsvalues.relid", "=", $id)->select("tblcustomfields.id", "tblcustomfieldsvalues.value")->get();
            if(count($clientCustomFields)) {
                $results->customFields = new \stdClass();
                foreach ($clientCustomFields as $customField) {
                    $fieldId = $customField->id;
                    $fieldValue = $customField->value;
                    $results->customFields->{$fieldId} = $fieldValue;
                }
            }
            foreach ($results as &$field) {
                if(!is_object($field)) {
                    $field = iconv(mb_detect_encoding($field, mb_detect_order(), true), "UTF-8", $field);
                }
            }
            return $this->returnData(["status" => "success", "results" => $results]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function findClients()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $searched = array_get($requestData, "query", "");
            $results = \Illuminate\Database\Capsule\Manager::table("tblclients")->select("id", \Illuminate\Database\Capsule\Manager::raw("CONCAT(firstname, \" \", lastname) AS name"), "companyname AS company")->where(\Illuminate\Database\Capsule\Manager::raw("CONCAT(firstname, \" \", lastname, \" \",companyname) "), "like", "%" . $searched . "%")->orWhere("id", "=", $searched)->limit($this->limit)->orderBy("id")->get();
            return $this->returnData(["status" => "success", "results" => $results]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    public function findResources()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $searched = array_get($requestData, "query", "");
            $results = \mgCRM2\Models\Resource::select("id", \Illuminate\Database\Capsule\Manager::raw("CONCAT(name, \" \", lastname) AS name"))->where(\Illuminate\Database\Capsule\Manager::raw("CONCAT(name, \" \", lastname) "), "like", "%" . $searched . "%")->orWhere("id", "=", $searched)->limit($this->limit)->orderBy("id")->get();
            return $this->returnData(["status" => "success", "results" => $results]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    public function findCountry()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $searched = array_get($requestData, "query", "");
            $countryFile = get_coutry_dir();
            $country = [];
            if($countryFile["type"] === "json") {
                foreach (object_to_array(json_decode(file_get_contents($countryFile["dir"]), true)) as $key => $value) {
                    $value["code"] = $key;
                    $country[] = $value;
                }
            } else {
                require_once $countryFile["dir"];
                foreach ($countries as $key => $value) {
                    $country[] = ["code" => $key, "name" => $value];
                }
            }
            return $this->returnData(["status" => "success", "results" => $country]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    public function findTicket()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $searched = array_get($requestData, "query", "");
            $results = \Illuminate\Database\Capsule\Manager::table("tbltickets as t")->join("tblclients as c", "t.userid", "=", "c.id")->select("t.id", "t.title", "t.tid", "c.lastname", "c.firstname", "c.companyname")->where("t.tid", "like", "%" . $searched . "%")->orWhere("t.id", "=", $searched)->orWhere("t.title", "like", "%" . $searched . "%")->orWhere("c.firstname", "like", "%" . $searched . "%")->orWhere("c.lastname", "like", "%" . $searched . "%")->orWhere("c.companyname", "like", "%" . $searched . "%")->limit($this->limit)->orderBy("t.id")->get();
            return $this->returnData(["status" => "success", "results" => $results]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    public function findAdminsToReassign()
    {
        try {
            $admins = \mgCRM2\Models\Whmcs\Admin::select(["id", "roleid", "username", "firstname", "lastname", "email", \Illuminate\Database\Capsule\Manager::raw("CONCAT(firstname, ' ', lastname) as name")])->whereIn("roleid", $this->app->acl->getAssignedAccessRoles())->where("disabled", "=", 0)->get();
            return $this->returnData($admins->ToArray());
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    public function backgroundFormData()
    {
        try {
            $repository = new \mgCRM2\Repositories\Settings();
            $configs = $repository->getAdminPersonalizedSettings($this->app->currentAdmin->id)->toArray();
            $number = 1;
            $defaultMailBoxs = 0;
            $mailboxs = \mgCRM2\Models\Mailbox::filterIrrelevantParams($this->app->currentAdmin->toArray()["id"])->get()->toArray();
            if(count($mailboxs)) {
                foreach ($mailboxs as $id => $data) {
                    $mailboxs[$id]["type_name"] = "m";
                    $mailboxs[$id]["number"] = $number;
                    $number++;
                }
            }
            $tickets = \mgCRM2\Models\Whmcs\TicketDepartment::orderred()->filterIrrelevantParams()->get()->toArray();
            if(count($tickets)) {
                foreach ($tickets as $id => $data) {
                    $tickets[$id]["type_name"] = "t";
                    $tickets[$id]["number"] = $number;
                    $number++;
                }
            }
            $departments = array_merge($mailboxs, $tickets);
            if(isset($configs["defaultEmail"]) && $configs["defaultEmail"] != "") {
                foreach ($departments as $department) {
                    if($configs["defaultEmail"] === $department["fullemail"]) {
                        $defaultMailBoxs = $department["number"];
                    }
                }
            }
            $templates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelectWithEmailData()->onlyCrmType()->get();
            $systemEmail = (array) \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "Email")->take(1)->first(["value"]);
            $settings = \mgCRM2\Repositories\Settings::getSingleParameter("email_import_type");
            $showLeadColumn = $settings["email_import_type"] !== 1;
            return $this->returnData(["showLeadColumn" => $showLeadColumn, "departments" => $departments, "default_mail" => $defaultMailBoxs, "templates" => $templates->toArray(), "system_email" => $systemEmail["value"]]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    public function backgroundForFollowups()
    {
        try {
            $departments = \mgCRM2\Models\Whmcs\TicketDepartment::orderred()->filterIrrelevantParams()->get()->toArray();
            $templates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyCrmType()->get()->toArray();
            $smstemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyAdminType()->get()->toArray();
            $clienttemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyClientType()->get()->toArray();
            $admins = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->get()->toArray();
            $followupTypes = \mgCRM2\Models\FollowupType::orderred()->get()->toArray();
            $followupStatuses = \mgCRM2\Models\FollowupStatus::orderred()->get()->toArray();
            return $this->returnData(["departments" => $departments, "admins" => $admins, "followup" => ["types" => $followupTypes, "statuses" => $followupStatuses], "templates" => ["admin" => $templates, "sms" => $smstemplates, "client" => $clienttemplates]]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
}

?>