<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\ImportExport;

class Export extends \mgCRM2\Controllers\Source\AbstractController
{
    public function isZip()
    {
        try {
            $isClassExist = class_exists("ZipArchive");
            return $this->returnData(["isZip" => (bool) $isClassExist]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function exportContacts($format)
    {
        try {
            if(!\mgCRM2\Helpers\ContactExporter::getInstance()->isAllowedExtension($format)) {
                throw new \Exception("Unsupported file type");
            }
            \mgCRM2\Helpers\ContactExporter::getInstance()->generateDataToExport($format);
            $this->setUpOutputHeaders($format);
            \mgCRM2\Helpers\ContactExporter::getInstance()->render();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    private function setUpOutputHeaders($type, $filename = "export")
    {
        ob_end_clean();
        if(strtolower($type) == "pdf") {
            $filename .= ".pdf";
            header("Content-Type: application/pdf");
            header("Content-Disposition: attachment;filename=\"" . $filename . "\"");
            header("Cache-Control: max-age=0");
        } elseif(strtolower($type) == "ods") {
            $filename .= ".ods";
            header("Content-Type: application/vnd.oasis.opendocument.spreadsheet");
            header("Content-Disposition: attachment;filename=\"" . $filename . "\"");
            header("Cache-Control: max-age=0");
            header("Cache-Control: max-age=1");
            header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
            header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
            header("Cache-Control: cache, must-revalidate");
            header("Pragma: public");
        } elseif(strtolower($type) == "xls") {
            $filename .= ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment;filename=\"" . $filename . "\"");
            header("Cache-Control: max-age=0");
            header("Cache-Control: max-age=1");
            header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
            header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
            header("Cache-Control: cache, must-revalidate");
            header("Pragma: public");
        } elseif(strtolower($type) == "xlsx") {
            $filename .= ".xlsx";
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=\"" . $filename . "\"");
            header("Cache-Control: max-age=0");
            header("Cache-Control: max-age=1");
            header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
            header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
            header("Cache-Control: cache, must-revalidate");
            header("Pragma: public");
        } elseif(strtolower($type) == "csv") {
            $filename .= ".csv";
            header("Content-Type: application/octet-stream");
            header("Content-Disposition: attachment;filename=\"" . $filename . "\"");
            header("Cache-Control: max-age=0");
            header("Cache-Control: cache, must-revalidate");
            header("Pragma: public");
        }
        ob_end_clean();
    }
}

?>