<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\ImportExport;

class Import extends \mgCRM2\Controllers\Source\AbstractController
{
    public function uploadFile()
    {
        try {
            if(is_array($_FILES) && !empty($_FILES)) {
                $files = $_FILES;
            } else {
                $files = [];
            }
            \mgCRM2\Helpers\ManageFiles::moveUploadedFileForImport($files);
            return $this->returnData(["status" => "success", "msg" => "File has been uploaded"]);
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getFileSummaryFile()
    {
        try {
            return $this->returnData(\mgCRM2\Helpers\ContactImporter::getInstance()->getSummaryForUploadedFile());
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function importContacts()
    {
        try {
            $howmany = \mgCRM2\Helpers\ContactImporter::getInstance()->runImportFromFile();
            return $this->returnData(["status" => "success", "msg" => sprintf("%d Contacts have been imported", $howmany)]);
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>