<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Notifications;

/**
 * Class to maintain actions for single lead instance
 */
class NotificationsHelpers extends \mgCRM2\Controllers\Source\AbstractController
{
    const CONTACT_ID_FOR_PARSING = "{contactId}";
    const CONTACT_FIRSTNAME_FOR_PARSING = "{contactFirstname}";
    const CONTACT_LASTNAME_FOR_PARSING = "{contactLastname}";
    const CONTACT_NOTES_LINK_FOR_PARSING = "{contactNotesLink}";
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Notifications();
    }
    public function createNotification()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        $startDate = \Carbon\Carbon::parse(array_get($data, "date_start"));
        $endDate = \Carbon\Carbon::parse(array_get($data, "date_end"));
        $startDate->hour = $endDate->minute = $endDate->second = 0;
        $endDate->hour = 23;
        $endDate->minute = $endDate->second = 59;
        try {
            $new = $this->repository->createNotification($data);
            $return = ["status" => "success", "msg" => "New Notification has been created", "new" => $new->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getNotificationList()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->getNorificationsListTableQuery($requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function getMineNotification()
    {
        try {
            if($this->app->config("isWhmcsAPIcall") === true) {
                $requestData = json_decode($this->app->request->getBody(), true);
                $adminID = array_get($requestData, "adminID");
            } else {
                $adminID = $this->app->currentAdmin->id;
            }
            $result = $this->repository->getMineNotificationList($adminID);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function deleteNotification($id)
    {
        try {
            $new = $this->repository->deleteNotification($id);
            $return = ["status" => "success", "msg" => "Notification has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function acceptNotification($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $this->repository->acceptNotification($requestData, $this->app->currentAdmin->id);
            $return = ["status" => "success", "msg" => "Notification has been accepted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getNotification($id)
    {
        try {
            $resultArray = $this->repository->getNotification($id);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function updateNotification($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $edited = $this->repository->updateNotification($id, $requestData);
            return $this->returnData(["status" => "success", "msg" => "The notification has been updated successfully", "new" => $edited->toArray()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function addAdminsNotificationFromMentions($mentionsContent, $resourceId = NULL)
    {
        $adminsToNotifications = $this->getAdminsFromNoteContent($mentionsContent);
        if(!empty($adminsToNotifications)) {
            $globals = (new \mgCRM2\Controllers\Api\Settings\GeneralSettings())->repository->getGlobal();
            $notificationInterval = (string) $globals["email_notification_duration"];
            $confirmation = $globals["enable_email_notification_confirmation"] == 1;
            $content = $globals["admin_mentions_content"];
            $startDate = new \DateTime();
            $endDate = (new \DateTime())->modify("+" . ($notificationInterval ?: "0") . " minutes");
            $content = $resourceId ? $this->parseNotificationContentByResourceId($content, $resourceId) : $content;
            $notificationData = ["class" => "", "type" => "temporary", "content" => $content, "date_start" => $startDate, "date_end" => $endDate, "confirmation" => $confirmation, "hide_after_confirm" => $confirmation, "admins" => $adminsToNotifications];
            $this->repository->createNotification($notificationData);
        }
    }
    public function parseNotificationContentByResourceId($content, $resourceId)
    {
        $content = preg_replace("/" . self::CONTACT_ID_FOR_PARSING . "/", $resourceId, $content);
        $contactRepo = new \mgCRM2\Repositories\Resources();
        $contact = $contactRepo->find($resourceId);
        if($contact->exists) {
            $content = preg_replace("/" . self::CONTACT_FIRSTNAME_FOR_PARSING . "/", $contact->name, $content);
            $content = preg_replace("/" . self::CONTACT_LASTNAME_FOR_PARSING . "/", $contact->lastname, $content);
        }
        $url = "#!/contacts/" . $resourceId . "/notes";
        return preg_replace("/" . self::CONTACT_NOTES_LINK_FOR_PARSING . "/", $url, $content);
    }
    public function getAdminsFromNoteContent($noteContent) : array
    {
        $foundedAdmins = [];
        $admins = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->get()->toArray();
        foreach ($admins as $admin) {
            if(!empty($admin["full"]) && preg_match("/" . $admin["full"] . "/", $noteContent)) {
                $foundedAdmins[] = $admin["id"];
            }
        }
        return $foundedAdmins;
    }
}

?>