<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Resources;

/**
 * Class to maintain actions for single lead instance
 */
class ContactrsList extends \mgCRM2\Controllers\Source\AbstractController
{
    public function queryTable($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            if($this->app->config("isWhmcsAPIcall") === true && array_get($requestData, "status") != NULL) {
                array_set($requestData, "params.search.predicateObject.status_id", array_get($requestData, "status"));
            }
            return $this->returnData($repo->parseRepositoriesForTable($requestData, false, $this->app->config("isWhmcsAPIcall")));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function queryArchiveTable()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            return $this->returnData($repo->parseRepositoriesForTable($requestData, true));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function changePriority()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->chagePiority($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function changeType()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->changeType($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function changeStatus()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->changeStatus($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function assignAdmin()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->assignAdmin($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function changeDateFollowups()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->changeDateFollowups($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function rescheduleReminders()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->rescheduleReminders($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function rescheduleOnAdminReminders()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo = new \mgCRM2\Repositories\Resources();
            $repo->rescheduleOnAdminReminders($requestData);
            return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function reassignLabels()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $requestData["selectedLabels"] = $requestData["selectedLabels"] ?? [];
            $labelIds = array_column($requestData["selectedLabels"], "id");
            switch ($requestData["action"]["id"]) {
                case 1:
                    $this->addLabels($requestData, $labelIds);
                    break;
                case 2:
                    $this->changeLabels($requestData, $labelIds);
                    break;
                case 3:
                    $this->removeLabels($requestData, $labelIds);
                    break;
                default:
                    return $this->returnData(["status" => "success", "msg" => "Resource has been updated."]);
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $e->getMessage()]);
        }
    }
    private function addLabels($requestData, $labelIds)
    {
        foreach ($requestData["massAction"] as $id) {
            $resource = (new \mgCRM2\Repositories\Resources())->getLabelsForId($id);
            $resourceLabels = array_column($resource->labels->toArray(), "id");
            $labelsForAdd = array_diff($labelIds, $resourceLabels);
            $resource->labels()->attach($labelsForAdd);
        }
    }
    private function changeLabels($requestData, $labelIds)
    {
        foreach ($requestData["massAction"] as $id) {
            $resource = (new \mgCRM2\Repositories\Resources())->getLabelsForId($id);
            $resource->labels()->detach();
            $resource->labels()->attach($labelIds);
        }
    }
    private function removeLabels($requestData, $labelIds)
    {
        foreach ($requestData["massAction"] as $id) {
            $resource = (new \mgCRM2\Repositories\Resources())->getLabelsForId($id);
            $resource->labels()->detach($labelIds);
        }
    }
}

?>