<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Resources;

/**
 * Class to maintain actions for maintain notes
 */
class ResourceNotes extends \mgCRM2\Controllers\Source\AbstractController
{
    /**
     * if there is set limit for queries
     * 
     * @var integer
     */
    protected $queryLimit;
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Notes();
    }
    public function get($id)
    {
        return $this->getList($id, false);
    }
    public function getLimited($id, $limit)
    {
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($limit)) {
            $this->queryLimit = intval($limit);
        }
        return $this->getList($id, false);
    }
    public function getWithDeleted($id)
    {
        return $this->getList($id, true);
    }
    public function getAdmins()
    {
        try {
            $result = \mgCRM2\Models\Whmcs\Admin::onlyActive()->get()->toArray();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($result);
    }
    public function getWithDeletedLimited($id, $limit)
    {
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($limit)) {
            $this->queryLimit = intval($limit);
        }
        return $this->getList($id, true);
    }
    protected function getList($id, $withTrashed = false)
    {
        try {
            $result = $this->repository->getModel()->where("resource_id", "=", $id)->joinAdminAvatar()->orderBy("updated_at", "DESC")->orderBy("created_at", "DESC");
            if($withTrashed) {
                $result = $result->withTrashed();
            }
            if(!is_null($this->queryLimit)) {
                $result = $result->take($this->queryLimit);
            }
            $resultArray = $result->get()->toArray();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function addNote($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $new = $this->repository->addNoteForResource($id, $requestData);
            if($new->id) {
                return $this->returnData(["status" => "success", "msg" => "The new note has been created successfully", "new" => $new->toArray()]);
            }
            throw new \Exception("Something went wrong.");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function softDelete($id, $noteID)
    {
        try {
            $note = $this->repository->softDeleteFor($id, $noteID);
            return $this->returnData(["status" => "success", "msg" => "Note has been hidden", "updated_at" => $note->updated_at->toDateTimeString(), "deleted_at" => $note->deleted_at->toDateTimeString()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function forceDelete($id, $noteID)
    {
        try {
            $note = $this->repository->forceDeleteFor($id, $noteID);
            return $this->returnData(["status" => "success", "msg" => "Note has been deleted"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function restoreDeleted($id, $noteID)
    {
        try {
            $note = $this->repository->restoreNote($id, $noteID);
            return $this->returnData(["status" => "success", "msg" => "Note has been restored", "updated_at" => $note->updated_at->toDateTimeString(), "deleted_at" => NULL]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function editNote($id, $noteID)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $note = $this->repository->handleEditContent($id, $noteID, $requestData);
            return $this->returnData(["status" => "success", "msg" => "Note has been restored", "note" => $note->toArray()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>