<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Resources;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Class to maintain actions for single lead instance
 */
class ResourceSingle extends \mgCRM2\Controllers\Source\AbstractController
{
    public function getMainDetails($id)
    {
        try {
            $resource = \mgCRM2\Models\Resource::withTrashed()->with(["admin", "status", "ticket", "client", "campaigns", "labels"])->find($id);
            $resultArray = $resource->toArray();
            $resultArray["labels"] = \mgCRM2\Helpers\LabelHelper::addLabelColor($resultArray["labels"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function getTypeDetails($id)
    {
        try {
            $resource = \mgCRM2\Models\Resource::withTrashed()->with(["type"])->find($id);
            $lead = $resource->toArray();
            $resultArray = $lead["type"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function syncAssignedCampaigns($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            $resource->syncAssignedCampaigns($requestData);
            return $this->returnData(["status" => "success", "msg" => "Campaigns has been updated", "updated_at" => $resource->updated_at->toDateTimeString()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function updateSingleParam($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            if(!empty($requestData["phone"])) {
                $requestData["phone"] = \mgCRM2\Helpers\PhoneNumberParser::parsePhoneNumber($requestData["phone"]);
            }
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            $resource->updateSingleParam($requestData);
            return $this->returnData(["status" => "success", "msg" => "Parameter has been updated", "updated_at" => is_string($resource->updated_at) ? $resource->updated_at : $resource->updated_at->toDateTimeString()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function reassignTicket($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $ticketID = array_get($requestData, "ticket_id", false);
            $unassign = array_get($requestData, "unassign", false);
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            if($unassign === true) {
                $resource->unassignTicket();
                $return = ["status" => "success", "msg" => "Ticket has been unassigned", "updated_at" => $resource->updated_at->toDateTimeString(), "ticket_id" => $resource->ticket_id, "ticket" => false];
            } else {
                $resource->reassignTicket($ticketID);
                $return = ["status" => "success", "msg" => "Ticket has been assigned", "updated_at" => $resource->updated_at->toDateTimeString(), "ticket_id" => $resource->ticket_id, "ticket" => $resource->ticket->toArray()];
            }
            return $this->returnData($return);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function reassignClient($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $clientID = array_get($requestData, "client_id", false);
            $unassign = array_get($requestData, "unassign", false);
            $quotesRepo = new \mgCRM2\Repositories\ResourceQuotes();
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            $quotesRepo->removeRelationForContactAndQuotes($resource->id);
            if($unassign === true) {
                $resource->unassignClient();
                $return = ["status" => "success", "msg" => "Client has been unassigned", "updated_at" => $resource->updated_at->toDateTimeString(), "client_id" => $resource->client_id, "client" => false];
            } else {
                $resource->reassignClient($clientID);
                $quotesRepo->sync($resource->id);
                $return = ["status" => "success", "msg" => "Client has been assigned", "updated_at" => $resource->updated_at->toDateTimeString(), "client_id" => $resource->client_id, "client" => $resource->client->toArray()];
            }
            return $this->returnData($return);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function reassignLabels($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $labels = array_get($requestData, "labels", false);
            $unassign = array_get($requestData, "unassign", false);
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            if($unassign === true) {
                $resource->unassignLabels();
                $return = ["status" => "success", "msg" => "Labels has been unassigned", "updated_at" => $resource->updated_at->toDateTimeString()];
            } else {
                $resource->reassignLabels($labels);
                $return = ["status" => "success", "msg" => "Labels has been assigned", "updated_at" => $resource->updated_at->toDateTimeString()];
            }
            return $this->returnData($return);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function reassignCountry($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $country = array_get($requestData, "country", false);
            $unassign = array_get($requestData, "unassign", false);
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            if($unassign === true) {
                $resource->unassignCountry();
                $return = ["status" => "success", "msg" => "Client has been unassigned", "updated_at" => $resource->updated_at->toDateTimeString(), "country" => false];
            } else {
                $resource->reassignCountry($country);
                $return = ["status" => "success", "msg" => "Client has been assigned", "updated_at" => $resource->updated_at->toDateTimeString(), "country" => $resource->country];
            }
            return $this->returnData($return);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function softDelete($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $resource = \mgCRM2\Models\Resource::find($id);
            $resource->delete();
            return $this->returnData(["status" => "success", "msg" => "The contact has been moved to the archive successfully", "updated_at" => is_string($resource->updated_at) ? $resource->updated_at : $resource->updated_at->toDateTimeString(), "deleted_at" => is_string($resource->deleted_at) ? $resource->deleted_at : $resource->deleted_at->toDateTimeString()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function forceDelete($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            $resource->forceDelete();
            return $this->returnData(["status" => "success", "msg" => "Contact has been deleted."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function forceMassActionDelete()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(isset($requestData["resourceIds"])) {
                foreach (\mgCRM2\Models\Resource::withTrashed()->whereIn("id", $requestData["resourceIds"])->get() as $recource) {
                    $recource->forceDelete();
                }
            }
            return $this->returnData(["status" => "success", "msg" => "Contacts has been delete."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function moveToArchiveClients()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(isset($requestData["resourceIds"])) {
                foreach (\mgCRM2\Models\Resource::withTrashed()->whereIn("id", $requestData["resourceIds"])->get() as $recource) {
                    $recource->delete();
                }
            }
            return $this->returnData(["status" => "success", "msg" => "Contacts has been sent to Archive."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function restoreFromArchiveClients()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(isset($requestData["resourceIds"])) {
                foreach (\mgCRM2\Models\Resource::withTrashed()->whereIn("id", $requestData["resourceIds"])->get() as $recource) {
                    $recource->restore();
                }
            }
            return $this->returnData(["status" => "success", "msg" => "Contacts has been restored from Archive."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function restoreSoftDeleted($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $resource = \mgCRM2\Models\Resource::withTrashed()->find($id);
            $resource->restore();
            return $this->returnData(["status" => "success", "msg" => "The contact has been restored from the archive successfully", "updated_at" => is_string($resource->updated_at) ? $resource->updated_at : $resource->updated_at->toDateTimeString(), "deleted_at" => NULL]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
}

?>