<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class Automations extends \mgCRM2\Controllers\Source\AbstractController
{
    /**
     * @var \mgCRM2\Repositories\Automations 
     */
    protected $repository;
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Automations();
    }
    public function getAutomation($id)
    {
        try {
            return $this->returnData($this->repository->getDetails($id));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getList()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            return $this->returnData($this->repository->getListTableQuery($requestData));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function createAutomation()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            return $this->returnData(["id" => $this->repository->createAutomation($requestData), "status" => "success", "msg" => "The automation has been created successfully"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function updateParam($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $this->repository->updateParam($id, $requestData);
            return $this->returnData(["status" => "success", "msg" => "The automation has been updated successfully"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function deleteAutomation($id)
    {
        try {
            $automation = \mgCRM2\Models\Automations::find($id);
            $automation->fill(["status" => false])->save();
            $automation->delete();
            return $this->returnData(["status" => "success", "msg" => "The automation has been deleted successfully."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function sortRule($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $this->updateSort($requestData["rules"]);
            return $this->returnData(["status" => "success", "msg" => "The automation rule has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function addRule($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $rule = new \mgCRM2\Models\AutomationRules($requestData);
            $rule->save();
            return $this->returnData(["data" => $rule->toArray(), "status" => "success", "msg" => "The automation rule has been created."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function editRule($id, $idRule)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            unset($requestData["rules"]);
            unset($requestData["id"]);
            $rule = \mgCRM2\Models\AutomationRules::find($idRule);
            $rule->fill($requestData)->save();
            return $this->returnData(["status" => "success", "msg" => "The automation rule has been updated."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function deleteRule($id, $idRule)
    {
        try {
            $rule = \mgCRM2\Models\AutomationRules::where("id", $idRule)->with("rules")->first();
            if($rule) {
                $this->removeChildren($rule);
                $rule->delete();
                return $this->returnData(["status" => "success", "msg" => "The automation rule has been deleted."]);
            }
            return $this->returnData(["status" => "error", "msg" => "Something went wrong."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function generalData($id)
    {
        try {
            $return = ["templates" => []];
            $contactTypes = [["id" => 0, "name" => "Any Contact ( or New Contact )"]];
            foreach (\mgCRM2\Models\ResourceType::orderred()->onlyActive()->pluck("name", "id") as $resID => $name) {
                $contactTypes[] = ["id" => $resID, "name" => $name];
            }
            $return["fields"] = \mgCRM2\Helpers\TablesFieldViews::getAllColumnsWithOptions();
            $return["contactType"] = $contactTypes;
            $return["templates"]["admin"] = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyCrmType()->get()->toArray();
            $return["templates"]["sms"] = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyAdminType()->get()->toArray();
            $return["templates"]["client"] = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyClientType()->get()->toArray();
            $return["admins"] = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->get()->toArray();
            $return["labels"] = array_merge([["id" => 0, "name" => "Any", "full" => "Any"]], \mgCRM2\Models\Label::all()->toArray());
            $return["followupType"] = \mgCRM2\Models\FollowupType::orderred()->get()->toArray();
            $return["contacts"] = \mgCRM2\Models\Resource::all()->toArray();
            $return["emailTypes"] = \mgCRM2\Models\Whmcs\EmailTemplates::select("id", "name")->whereIn("type", ["product", "invoice", "domain", "general"])->get()->toArray();
            return $this->returnData(["status" => "error", "data" => $return]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    protected function removeChildren($rule)
    {
        foreach ($rule->rules as $activeRule) {
            $this->removeChildren($activeRule);
            $activeRule->delete();
        }
        return $this;
    }
    protected function updateSort($rules)
    {
        foreach ($rules as $rule) {
            if(0 < count($rule["rules"])) {
                $this->updateSort($rule["rules"]);
            }
            \mgCRM2\Models\AutomationRules::updateOrCreate(["id" => $rule["id"]], ["parent_id" => (int) $rule["parent_id"], "order" => (int) $rule["order"]]);
        }
    }
}

?>