<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class FieldsManage extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Fields();
    }
    public function query()
    {
        try {
            $groups = $this->repository->getModel()->orderBy("order", "ASC")->with("group")->get()->toArray();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($groups);
    }
    public function addField()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        $data["order"] = $this->getNewLabelOrder($data["group_id"]);
        try {
            $new = $this->repository->create($data);
            if($new) {
                $return = ["status" => "success", "msg" => "New Field has been created", "new" => $new->toArray()];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function updateField($id)
    {
        $data = json_decode($this->app->request->getBody(), true);
        try {
            $result = $this->repository->updateSingleParamInModel($id, $data);
            if($data["type"] == "checkbox") {
                $field = $this->repository->find($id);
                foreach ($field->options as $index => $option) {
                    if($index != 0) {
                        $option->delete();
                    }
                }
            }
            $return = ["status" => "success", "msg" => "Field has been updated", "new" => $result->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function deleteField($id)
    {
        try {
            $result = $this->repository->delete($id);
            if(!$result) {
                throw new \Exception("Something Went Wrong. Could not deleted Role.");
            }
            $return = ["status" => "success", "msg" => "Field has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function reorder()
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $newOrder = array_get($data, "order", []);
            if($this->repository->reorder($newOrder)) {
                $return = ["status" => "success", "msg" => "Order Has has been updated"];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            $return = ["status" => "error", "msg" => $e->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getField($id)
    {
        try {
            $field = $this->repository->find($id);
            if(!$field) {
                throw new \Exception("Couldnt find field with id " . $id);
            }
            $return = $field->toArray();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function addValidator($id)
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            if(!isset($data["type"])) {
                throw new \Exception("You must specify type");
            }
            $new = $this->repository->addFieldValidator($id, $data);
            if($new) {
                $return = ["status" => "success", "msg" => "New Validator has been assigned", "new" => $new->toArray()];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getValidatorFor($id)
    {
        try {
            $validators = \mgCRM2\Models\FieldValidatorConfig::where("field_id", "=", $id)->get();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($validators->toArray());
    }
    public function deleteValidator($id, $validatorID)
    {
        try {
            $validator = \mgCRM2\Models\FieldValidatorConfig::where("field_id", "=", $id)->where("id", "=", $validatorID)->first();
            $validator->delete();
            $return = ["status" => "success", "msg" => "Validator Assigned to Field has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function addFieldOption($id)
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $new = new \mgCRM2\Models\FieldOption();
            $new->create($data);
            if($new) {
                $return = ["status" => "success", "msg" => "New Option has been added"];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getFieldOption($id)
    {
        try {
            $list = \mgCRM2\Models\FieldOption::where("field_id", "=", $id)->get();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($list->toArray());
    }
    public function deleteFieldOption($id, $optionsID)
    {
        try {
            $option = \mgCRM2\Models\FieldOption::where("field_id", "=", $id)->where("id", "=", $optionsID)->first();
            $option->delete();
            $return = ["status" => "success", "msg" => "Option has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function updateOption($id, $optionsID)
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $option = \mgCRM2\Models\FieldOption::where("field_id", "=", $id)->where("id", "=", $optionsID)->firstOrFail();
            $option->updateValue(array_get($data, "value", false));
            return $this->returnData($option->toArray());
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getWithOptionsValidators()
    {
        try {
            $groups = $this->repository->getModel()->orderBy("order", "ASC")->with("group")->get();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($groups->toArray());
    }
    private function getNewLabelOrder($groupId)
    {
        $item = $this->repository->where("group_id", "=", $groupId)->orderBy("order", "DESC")->first();
        return $item && is_numeric($item->order) ? ++$item->order : 0;
    }
}

?>