<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class GeneralSettings extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Settings();
    }
    public function get()
    {
        try {
            $configs = $this->repository->getGlobal();
            return $this->returnData($configs);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getWithStatus()
    {
        try {
            $monitor = \mgCRM2\Services\Monitor::getInstance();
            $globalSettings = $this->repository->getGlobal();
            $selectedCalendars = $globalSettings["followups_synch_provider"];
            $calendarList = "";
            try {
                if($selectedCalendars[0]["id"] === 1 || $selectedCalendars[1]["id"] === 1) {
                    $calendarList = (new \mgCRM2\Models\GoogleModel())->getCalendarList();
                }
            } catch (\Exception $ex) {
            }
            $return = ["global" => $this->repository->getGlobal(), "calendar_list" => $calendarList, "templates" => \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyCrmType()->get()->toArray(), "status" => ["integrations" => $monitor->checkIntegrations(), "emails" => $monitor->getEmailTemplatesNum(), "cron" => $monitor->checkCronStatus()]];
            return $this->returnData($return);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function update()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(!empty($requestData)) {
                $this->repository->updateGlobals($requestData);
                return $this->returnData(["status" => "success", "msg" => "The global settings have been updated successfully"]);
            }
            throw new \Exception("Empty Data");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function authGoogle()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(!empty($requestData)) {
                $this->repository->updateGlobals($requestData);
                $auth = new \mgCRM2\Helpers\AuthGoogle($this->repository->getGlobal(), $this->app);
                $auth->deleteToken();
                $url = $auth->createUrl();
                return $this->returnData(["isClick" => $auth->isSend(), "url" => $url, "status" => "success", "msg" => "Calendar has been authorized."]);
            }
            throw new \Exception("Empty Data");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["isClick" => false, "status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function returnAuth()
    {
        try {
            $code = $_GET["code"];
            $auth = new \mgCRM2\Helpers\AuthGoogle($this->repository->getGlobal(), $this->app);
            $client = $auth->getClient();
            $client->fetchAccessTokenWithAuthCode($code);
            $auth->setToken($client->getAccessToken());
            $lastWorld = $_SERVER["SCRIPT_NAME"];
            if(substr($lastWorld, 0, 1) == "/") {
                $backUrl = (isset($_SERVER["HTTPS"]) && strtoupper($_SERVER["HTTPS"]) == "ON" ? "https://" : "http://") . $_SERVER["HTTP_HOST"] . $lastWorld;
            } else {
                $backUrl = (isset($_SERVER["HTTPS"]) && strtoupper($_SERVER["HTTPS"]) == "ON" ? "https://" : "http://") . $_SERVER["HTTP_HOST"] . "/" . $lastWorld;
            }
            header("Location: " . $backUrl . "#!/settings/general/followups");
            exit;
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getTableLabels()
    {
        try {
            $repo = new \mgCRM2\Repositories\Labels();
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $labels = $repo->parseForTable($requestData);
            return $this->returnData($labels);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getSingleLabel($id)
    {
        try {
            $repo = new \mgCRM2\Repositories\Labels();
            $label = $repo->getLabel($id);
            return $this->returnData($label);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function removeLabel($id)
    {
        try {
            $repo = new \mgCRM2\Repositories\Labels();
            $repo->deleteLabel($id);
            return $this->returnData(["status" => "success", "msg" => "The label has been deleted successfully"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function createLabel()
    {
        try {
            $repo = new \mgCRM2\Repositories\Labels();
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo->addLabel($requestData);
            return $this->returnData(["status" => "success", "msg" => "Label has been create."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function updateLabel($id)
    {
        try {
            $repo = new \mgCRM2\Repositories\Labels();
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $repo->updateLabel($id, $requestData);
            return $this->returnData(["status" => "success", "msg" => "Label has been update."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function reorderLabels()
    {
        try {
            $repo = new \mgCRM2\Repositories\Labels();
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $newOrder = array_flip(array_get($data, "order", []));
            if($repo->reorder($newOrder)) {
                $return = ["status" => "success", "msg" => "Order Has has been updated"];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            $return = ["status" => "error", "msg" => $e->getMessage()];
        }
        return $this->returnData($return);
    }
}

?>