<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class PermissionGroups extends \mgCRM2\Controllers\Source\AbstractController
{
    /**
     * @var \mgCRM2\Repositories\PermissionRoles 
     */
    protected $repository;
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\PermissionRoles();
    }
    public function getWhmcsAdminRoles()
    {
        try {
            $ids = \mgCRM2\Models\Whmcs\AdminRole::getAssignable();
            if(empty($ids)) {
                return $this->returnData($ids);
            }
            $roles = \mgCRM2\Models\Whmcs\AdminRole::ByIds($ids)->get();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($roles->toArray());
    }
    public function getRoles()
    {
        try {
            $statuses = $this->repository->all();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($statuses->toArray());
    }
    public function getProviders()
    {
        try {
            $providers = $this->repository->getProviders();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($providers);
    }
    public function addRole()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        if(!$data["description"]) {
            $data["description"] = "";
        }
        try {
            $newStatus = $this->repository->create($data);
            $return = ["status" => "success", "msg" => "New Role has been created", "new" => $newStatus->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function updateRole($id)
    {
        $data = json_decode($this->app->request->getBody(), true);
        try {
            $result = $this->repository->updateSingleParamInModel($id, $data);
            $return = ["status" => "success", "msg" => "The role has been updated successfully", "new" => $result->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function deleteRole($id)
    {
        try {
            $result = $this->repository->delete($id);
            if(!$result) {
                throw new \Exception("Something Went Wrong. Could not deleted Role.");
            }
            $return = ["status" => "success", "msg" => "The role has been deleted successfully"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getParsedRules()
    {
        return $this->returnData($this->app->acl->getRules());
    }
    public function getRulesConfig()
    {
        return $this->returnData($this->app->acl->getRulesConfig());
    }
    public function getMinePermissions()
    {
        $r = $this->app->acl->getCurrentAdminRules();
        return $this->returnData($r);
    }
}

?>