<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class PersonalSettings extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Settings();
    }
    public function get()
    {
        try {
            $configs = $this->repository->getAdminPersonalizedSettings($this->app->currentAdmin->id);
            return $this->returnData($configs->toArray());
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function update()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(!empty($requestData)) {
                $this->repository->updateManuForAdmin($this->app->currentAdmin->id, $requestData);
                return $this->returnData(["status" => "success", "msg" => "Personal Settings Has Been Updated"]);
            }
            throw new \Exception("Empty Data");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>