<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class WebForms extends \mgCRM2\Controllers\Source\AbstractController
{
    /**
     * @var \mgCRM2\Repositories\WebForms
     */
    protected $repository;
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\WebForms();
    }
    public function getCreateParams()
    {
        try {
            $resultArray = [];
            $statussesRepository = new \mgCRM2\Repositories\FieldStatuses();
            $statusses = $statussesRepository->getActive();
            $resultArray["statuses"] = $statusses->toArray();
            $admins = \mgCRM2\Models\Whmcs\Admin::select(["id", "roleid", "username", "firstname", "lastname", "email", \Illuminate\Database\Capsule\Manager::raw("CONCAT(firstname, ' ', lastname) as name")])->whereIn("roleid", $this->app->acl->getAssignedAccessRoles())->where("disabled", "=", 0)->get();
            $resultArray["admins"] = $admins->toArray();
            $resultArray["currentAdmin"] = $this->app->currentAdmin->toArray();
            $resultArray["labels"] = \mgCRM2\Helpers\LabelHelper::addLabelColor(\mgCRM2\Models\Label::all()->toArray());
            $resultArray["followups"] = \mgCRM2\Models\FollowupType::all()->toArray();
            $resultArray["followupStatus"] = \mgCRM2\Models\FollowupStatus::orderred()->get()->toArray();
            $resultArray["resources"] = \mgCRM2\Models\Resource::all()->toArray();
            $this->returnData($resultArray);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function createWebForm()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $this->repository->createNew($requestData);
            return $this->returnData(["status" => "success", "msg" => \mgCRM2\Services\Language::translate("create.webform.success")]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function updateWebForm()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $this->repository->updateFrom($requestData);
            return $this->returnData(["status" => "success", "msg" => \mgCRM2\Services\Language::translate("update.webform.success")]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function deleteWebForm($id)
    {
        try {
            $this->repository->delete($id);
            $return = ["status" => "success", "msg" => \mgCRM2\Services\Language::translate("delete.webform.success")];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getWebFromDetails($id)
    {
        try {
            return $this->returnData($this->repository->getDetails($id));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getWebFormsList()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            return $this->returnData($this->repository->getWebFromListTableQuery($requestData));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function createContact()
    {
        $requestData = json_decode($this->app->request->getBody(), true);
        $requestData = is_array($requestData) ? $requestData : [];
        $deleteKeys = [];
        foreach ($requestData["form_data"] as $key => $value) {
            $originKey = "";
            $deleteKeys[] = $key;
            foreach (explode("_", $key) as $ascii) {
                $originKey .= mb_convert_encoding("&#" . intval($ascii) . ";", "UTF-8", "HTML-ENTITIES");
            }
            $requestData["form_data"][$originKey] = $value;
        }
        foreach ($deleteKeys as $key) {
            unset($requestData["form_data"][$key]);
        }
        $webformid = array_get($requestData, "form_data.MGCRM_webform_id", NULL);
        $webform = $this->repository->getWebFormById($webformid);
        $urls = \mgCRM2\Helpers\WebForms::parseUrlStringToArray($webform["static"]["url"]);
        try {
            if(!$webform) {
                throw new \Exception(\mgCRM2\Services\Language::translate("notFound.webform.message") . ": #" . $webformid);
            }
            $originUrl = $requestData["originUrl"];
            if(!\mgCRM2\Helpers\UrlHelper::checkOriginUrlFits($originUrl, $urls)) {
                throw new \Exception(\mgCRM2\Services\Language::translate("noAssociated.webform.message"));
            }
            $params = $this->getParamsToCreateContact($requestData["form_data"], $webform["fields"]);
            $params["assignedAdmin"]["id"] = $webform["static"]["admin_id"];
            $params["assignedStatus"]["id"] = $webform["static"]["status_id"];
            $params["assignedType"]["id"] = $webform["static"]["type_id"];
            $params["labels"] = is_array($webform["static"]["labels"]) ? $webform["static"]["labels"] : \mgCRM2\Helpers\WebForms::getLabelsStringAsArray($webform["static"]["labels"]);
            $this->validateCustomFields($this->filterCustomFields($webform["fields"]), $params);
            if(!$webform["static"]["duplicate_email"] && 0 < \mgCRM2\Models\Resource::where("email", $params["static"]["email"])->count()) {
                throw new \Exception(\mgCRM2\Services\Language::translate("webform.client.exist.email"));
            }
            if($webform["static"]["create_followup"]) {
                $this->checkFollowupDate($requestData["form_data"]["followupDate"]);
            }
            $resource = new \mgCRM2\Repositories\Resources();
            $resource->createNewLead($params);
            if($webform["static"]["create_followup"]) {
                $followupParams = ["resourceId" => $resource->getModel()->id, "type" => $webform["static"]["followup_label"], "followupStatus" => $webform["static"]["followup_status"], "admin" => $params["assignedAdmin"]["id"], "date" => $requestData["form_data"]["followupDate"]];
                $this->addFollowupByParams($followupParams);
            }
            unset($requestData["form_data"]["MGCRM_webform_id"]);
            $fields = $requestData["form_data"];
            $this->repository->increseQuantity($webformid, $fields, $resource);
            $log = new \mgCRM2\Models\WebFormLog(["webform_id" => $webformid, "message" => $_SERVER["REMOTE_ADDR"]]);
            $log->save();
            header("HTTP/1.1 200 OK");
            return $this->returnData(["status" => "success", "msg" => \mgCRM2\Services\Language::translate("webform.client.contact.created"), "urls" => $urls]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage(), "urls" => $urls]);
        }
    }
    private function filterCustomFields($fields)
    {
        return array_filter($fields, function ($field) {
            return is_numeric($field["field_id"]);
        });
    }
    private function checkFollowupDate($date)
    {
        if($date) {
            if(!\Carbon\Carbon::now()->lte(\Carbon\Carbon::parse($date))) {
                throw new \Exception(\mgCRM2\Services\Language::translate("dateInFuture.webform.message"));
            }
        } else {
            throw new \Exception(\mgCRM2\Services\Language::translate("dateCannotBeEmpty.webform.message"));
        }
    }
    private function addFollowupByParams($params)
    {
        $followupStatuses = new \mgCRM2\Repositories\FollowupStatuses();
        try {
            $resourceId = $params["resourceId"];
            unset($params["resourceId"]);
            $params["status"] = $params["followupStatus"] ?? $followupStatuses->getPendingStatusId();
            if(empty($params["status"])) {
                throw new \Exception(\mgCRM2\Services\Language::translate("createFollowupError.webform.message"));
            }
            $followup = new \mgCRM2\Repositories\Followups();
            $followup->createFollowup($resourceId, $params);
        } catch (\Exception $ex) {
            throw new \Exception(\mgCRM2\Services\Language::translate("createFollowupError.webform.message"));
        }
    }
    private function validateCustomFields($fields, $params)
    {
        $fieldsRepo = new \mgCRM2\Repositories\Fields();
        $fieldValidatorsRepo = new \mgCRM2\Repositories\FieldValidators();
        foreach ($fields as $webformField) {
            $value = $params["dynamic"][$webformField["field_id"]];
            $field = $fieldsRepo->find($webformField["field_id"]);
            $validators = $fieldValidatorsRepo->getValidatorsByFieldId($webformField["field_id"]);
            foreach ($validators as $validator) {
                \mgCRM2\Helpers\WebForms::validateField($validator, $value, $field->type);
            }
        }
    }
    public function getWebFromHtml($id)
    {
        $data = $this->repository->getDetails($id);
        $fields = new \mgCRM2\Repositories\Fields();
        $result = [];
        foreach ($data["fields"] as &$f) {
            $model = $fields->getModel();
            $field = $model->find($f["field_id"]);
            $f["title"] = $f["description"] ?: $field["description"];
            $f["type"] = $f["type"] ?: $field["type"];
            $f["options"] = !empty($f["options"]) ? $f["options"] : \mgCRM2\Models\FieldOption::where("field_id", "=", $f["field_id"])->get()->toArray();
            $result[] = $this->parseFieldToHTML($f);
        }
        if($this->checkWebformToCreateFollowup($data)) {
            $result[] = $this->generateFollowupDatePicker();
        }
        $address = $this->getWhmcsAddress();
        $html = $this->parseHTMLForm($id, $address, implode("<br />\n", $result));
        return $this->returnData(["html" => $html]);
    }
    protected function checkWebformToCreateFollowup($data)
    {
        return $data["static"] && $data["static"]["createFollowup"] == 1;
    }
    protected function generateFollowupDatePicker()
    {
        return "<label>Follow-up Date</label>\n<input type='datetime-local' name='followupDate' value='' class='form-control'><br />";
    }
    private function canCreateNewContact($webformid, $timeout)
    {
        $repo = new \mgCRM2\Repositories\WebFormsLogs();
        if(!$repo->getModel()->where("webform_id", "=", $webformid)->where("message", "=", $_SERVER["REMOTE_ADDR"])->get()->toArray()) {
            return true;
        }
        $logs = $repo->getModel()->where("webform_id", "=", $webformid)->where("message", "=", $_SERVER["REMOTE_ADDR"])->whereRaw("`date` < (SELECT DATE_SUB(NOW(), INTERVAL " . $timeout . " SECOND))")->get()->toArray();
        if(empty($logs)) {
            return false;
        }
        $repo->getModel()->where("webform_id", "=", $webformid)->where("message", "=", $_SERVER["REMOTE_ADDR"])->delete();
        return true;
    }
    private function getParamsToCreateContact($data, $fields)
    {
        $result = [];
        foreach ($fields as $field) {
            foreach ($data as $key => $value) {
                $key = str_replace("_", " ", $key);
                if($field["custom_name"] == $key) {
                    if($field["field_id"] == "R1") {
                        $result["static"]["name"] = $value;
                    } elseif($field["field_id"] == "R2") {
                        $result["static"]["lastname"] = $value;
                    } elseif($field["field_id"] == "R3") {
                        $result["static"]["email"] = $value;
                    } elseif($field["field_id"] == "R4") {
                        $result["static"]["phone"] = $value;
                    } elseif($field["field_id"] == "R5") {
                        $result["static"]["country"] = $value;
                    } else {
                        $result["dynamic"][$field["field_id"]] = $value;
                    }
                }
            }
        }
        return $result;
    }
    private function parseHTMLForm($webform_id, $address, $inputs)
    {
        $htmlfile = CRM_APP_PATH . DS . ".." . DS . "templates" . DS . "ModulesGarden" . DS . "app" . DS . "settings" . DS . "webforms" . DS . "templates" . DS . "webform.html";
        $html = file_get_contents($htmlfile);
        $html = str_replace("#WEBFORMID#", $webform_id, $html);
        $html = str_replace("#ADDRESS#", substr($address, -1) == "/" ? substr_replace($address, "", -1) : $address, $html);
        $html = str_replace("#INPUTS#", $inputs, $html);
        return $html;
    }
    private function parseFieldToHTML($field)
    {
        $result = "<label>" . $field["custom_name"] . "</label>";
        if($field["title"] != NULL && $field["title"] != "") {
            $result .= "&nbsp;<i class=\"fa\" title=\"" . $field["title"] . "\">&#xf29c;</i>";
        }
        $result .= "\n";
        switch ($field["type"]) {
            case "text":
                $result .= "<input type='text' name='" . $field["custom_name"] . "' class='form-control' value='' />\n";
                break;
            case "phone":
                $result .= "<input type='text' name='" . $field["custom_name"] . "' pattern='(\\(?\\+?[0-9]*\\.?\\)?)?[0-9_\\- \\(\\)]*' class='form-control' value='' />\n";
                break;
            case "textarea":
                $result .= "<textarea name='" . $field["custom_name"] . "' class='form-control'></textarea>\n";
                break;
            case "select":
                $options = [];
                foreach ($field["options"] as $option) {
                    $options[] = "<option value='" . $option["id"] . "' >" . $option["value"] . "</option>";
                }
                $optionsString = implode("", $options);
                $result .= "<select name='" . $field["custom_name"] . "' class='form-control'>" . $optionsString . "\n</select>\n";
                break;
            case "radio":
                foreach ($field["options"] as $option) {
                    $result .= "<input type='radio' name='" . $field["custom_name"] . "' value=\"" . $option["id"] . "\" >" . $option["value"] . "\n";
                }
                break;
            case "date":
                $result .= "<input type='date' name='" . $field["custom_name"] . "' value='' >" . $option["value"] . "\n";
                break;
            case "checkbox":
                foreach ($field["options"] as $option) {
                    $result .= "<input type='checkbox' name='" . $field["custom_name"] . "' value='' >" . $option["value"] . "\n";
                }
                break;
            case "numeric":
            default:
                return $result;
        }
    }
    private function getWhmcsAddress()
    {
        $address = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "SystemSSLURL")->first(["value", "setting"]);
        if(!empty($address->value)) {
            $result = $address->value;
        } else {
            $address = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "SystemURL")->first(["value", "setting"]);
            $result = $address->value;
        }
        return $result;
    }
}

?>