<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers;

/**
 * Note that it seems to be controller
 * but WHO CARE
 *
 * All Cron Logic is here, so ITS not really Controller or any MVC
 *
 */
class Cron extends Source\AbstractController
{
    protected $messages = [];
    protected $limit = 100;
    const LIMIT_MESSAGES_PER_RUN = 100;
    public function __construct()
    {
        parent::__construct();
        $this->updateCronStart();
        $this->setNewLimits();
        $messagesLimit = $this->app->configFile->get("app.cron.messagesLimit");
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($messagesLimit)) {
            $this->limit = $messagesLimit;
            unset($messagesLimit);
        }
        ob_clean();
    }
    public function setNewLimits()
    {
        @ini_set("memory_limit", "512M");
        @ini_set("max_execution_time", 0);
        @set_time_limit(0);
    }
    public function isInCLIMode()
    {
        return php_sapi_name() == "cli" && empty($_SERVER["REMOTE_ADDR"]);
    }
    public function run()
    {
        $this->addMessage("Cron Start");
        try {
            $this->handleMailboxes();
            $this->handleAutomations();
            $this->handleReminders();
            $this->handleMassMmessages();
            $this->addMessage("Cron Stop");
        } catch (\Exception $ex) {
            $this->addMessage("Cron Error: " . $ex->getMessage());
        }
        $this->output();
    }
    protected function addMessage($msg)
    {
        $this->messages[] = $msg;
        if($this->isInCLIMode()) {
            echo $msg . "\r\n";
        } else {
            echo $msg;
            echo "<br />";
        }
    }
    protected function output()
    {
        exit;
    }
    protected function updateCronStart()
    {
        $previous = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "mgCRM2_cron_previous")->select("value")->first();
        $last = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "mgCRM2_cron_last")->select("value")->first();
        $previousTimeStamp = intval(array_get((array) $last, "value", 0));
        $lastTimeStamp = time();
        if(is_null($previous)) {
            \Illuminate\Database\Capsule\Manager::insert("insert into tblconfiguration (value, setting) values (?, ?)", [$previousTimeStamp, "mgCRM2_cron_previous"]);
        } else {
            \Illuminate\Database\Capsule\Manager::update("update tblconfiguration set value = ? where setting = ?", [$previousTimeStamp, "mgCRM2_cron_previous"]);
        }
        if(is_null($last)) {
            \Illuminate\Database\Capsule\Manager::insert("insert into tblconfiguration (value, setting) values (?, ?)", [$lastTimeStamp, "mgCRM2_cron_last"]);
        } else {
            \Illuminate\Database\Capsule\Manager::update("update tblconfiguration set value = ? where setting = ?", [$lastTimeStamp, "mgCRM2_cron_last"]);
        }
    }
    protected function handleAutomations()
    {
        $automationManager = new \mgCRM2\Services\AutomationManager();
        $automationManager->execute();
    }
    protected function handleMailboxes()
    {
        include_whmcs();
        $getMail = 0;
        $getNotification = 0;
        foreach (\mgCRM2\Models\Mailbox::get() as $mailbox) {
            $mailer = new \mgCRM2\Services\IMAPMailer\MailerImap($mailbox);
            $mailer->openMailbox();
            $mailer->readMails();
            if($mailer->isError()) {
                $this->addMessage(sprintf("Error message: %s", $mailer->getErrorMessage()));
            } else {
                $getMail .= $mailer->getNewMail();
                $getNotification .= $mailer->getNewNotifications();
                $this->addMessage(sprintf("%s Mails to download By MailBox \"%s\"", $mailer->getNewMail(), $mailer->getMailboxName()));
            }
        }
        $this->addMessage(sprintf("%s mails has been downloaded", $getMail));
        $this->addMessage(sprintf("%s notifications has been created", $getNotification));
    }
    protected function handleReminders()
    {
        $remindersRepository = new \mgCRM2\Repositories\Reminders();
        $remindersToSent = $remindersRepository->cronGetRemindersToSent();
        $this->addMessage(sprintf("%s Reminders to sent", count($remindersToSent)));
        $counter = 0;
        foreach ($remindersToSent as $reminder) {
            if($this->limit <= 0) {
                $this->addMessage(sprintf("%s of %s has been sent", $counter, count($remindersToSent)));
            } else {
                try {
                    if($reminder->sent()) {
                        $counter++;
                        $this->limit--;
                    }
                } catch (\Exception $ex) {
                    $this->addMessage(sprintf("Unable to sent reminder #%s: %s", $reminder->id, $e->getMessage()));
                }
            }
        }
    }
    protected function handleMassMmessages()
    {
        $repo = new \mgCRM2\Repositories\MassMessageConfigs();
        $repo->generatePendingMassMessages();
        $collection = \mgCRM2\Models\MassMessagePending::with(["resource", "resource.status", "resource.type", "resource.admin", "resource.ticket", "messageConfig"])->fix()->take($this->limit)->get();
        $this->addMessage(sprintf("%s Messages to sent", count($collection)));
        $counter = 0;
        $counterTotal = \mgCRM2\Models\MassMessagePending::count();
        foreach ($collection as $message) {
            if($this->limit <= 0) {
                $this->addMessage(sprintf("Message %s of %s has been sent", $counter, $counterTotal));
            } else {
                try {
                    if($message->sent()) {
                        $counter++;
                        $this->limit--;
                    }
                } catch (\Exception $ex) {
                    $this->addMessage(sprintf("Unable to sent Messages #%s: %s", $message->id, $e->getMessage()));
                    $this->app->log->error("CRON: Unable to sent Messages #{id} for configuration {cid}. Error: {error}", ["id" => $message->id, "cid" => $message->mass_message_config_id, "error" => $e->getMessage()]);
                }
            }
        }
    }
}

?>