<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

/**
 * Class to maintain actions for single lead instance
 */
class ManageFiles
{
    public static function checkDirectory($path)
    {
        if(!file_exists($path)) {
            if(!mkdir($path, 493, true)) {
                throw new \Exception(sprintf("Unable to create directory '%s'", $path));
            }
        } elseif(!is_writable($path)) {
            throw new \Exception(sprintf("Directory '%s' is not writable", $path));
        }
    }
    public static function moveUploadedFileForResource($resourceID, $file)
    {
        if(empty($file)) {
            throw new \Exception("No file sent.");
        }
        $mainPath = \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("storage.path");
        $filesDir = \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("storage.files");
        $path = $mainPath . "/" . $filesDir;
        self::checkDirectory($path);
        $path .= "/" . $resourceID;
        self::checkDirectory($path);
        $error = array_get($file, "files.error.0", 0);
        if($error == UPLOAD_ERR_OK) {
            $fileOrgName = array_get($file, "files.name.0");
            $tmp = explode(".", $fileOrgName);
            $fileExtension = end($tmp);
            $fileTmpLocation = array_get($file, "files.tmp_name.0");
            $fileName = md5(microtime());
            $fullMovePath = sprintf("%s/%s.%s", $path, $fileName, $fileExtension);
            if(move_uploaded_file($fileTmpLocation, $fullMovePath)) {
                return ["location" => $fullMovePath, "name" => $fileName . "." . $fileExtension, "oryginal" => $fileOrgName];
            }
            throw new \Exception("Unable to move uploaded file");
        }
        switch ($error) {
            case UPLOAD_ERR_NO_FILE:
                throw new \Exception("No file sent.");
                break;
            case UPLOAD_ERR_INI_SIZE:
            case UPLOAD_ERR_FORM_SIZE:
                throw new \Exception("Exceeded file size limit.");
                break;
            default:
                throw new \Exception("Unknown errors.");
        }
    }
    public static function makeArrayPerFile(array $files = [])
    {
        $return = [];
        $errors = array_get($files, "files.error", []);
        $validIDs = [];
        foreach ($errors as $key => $error) {
            if($error == UPLOAD_ERR_OK) {
                $validIDs[] = $key;
            }
        }
        foreach ($validIDs as $key) {
            $return[] = ["name" => array_get($files, "files.name." . $key), "type" => array_get($files, "files.type." . $key), "tmp_name" => array_get($files, "files.tmp_name." . $key), "error" => array_get($files, "files.error." . $key), "size" => array_get($files, "files.size." . $key)];
        }
        return $return;
    }
    public static function moveUploadedFileForImport($files)
    {
        $file = array_shift(self::makeArrayPerFile($files));
        if(empty($file)) {
            throw new \Exception("No file sent.");
        }
        $path = \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("storage.path") . "/import";
        self::checkDirectory($path);
        $error = array_get($file, "error", 0);
        if($error == UPLOAD_ERR_OK) {
            $fileOrgName = array_get($file, "name");
            $tmp = explode(".", $fileOrgName);
            $fileExtension = end($tmp);
            $fileTmpLocation = array_get($file, "tmp_name");
            $fullMovePath = sprintf("%s/import.%s", $path, $fileExtension);
            if(!ContactImporter::getInstance()->isAllowedExtension($fileExtension)) {
                throw new \Exception("Unsupported file type");
            }
            $files = glob($path . "/*");
            foreach ($files as $file) {
                if(is_file($file)) {
                    unlink($file);
                }
            }
            if(move_uploaded_file($fileTmpLocation, $fullMovePath)) {
                return true;
            }
            throw new \Exception("Unable to move uploaded file");
        } else {
            switch ($error) {
                case UPLOAD_ERR_NO_FILE:
                    throw new \Exception("No file sent.");
                    break;
                case UPLOAD_ERR_INI_SIZE:
                case UPLOAD_ERR_FORM_SIZE:
                    throw new \Exception("Exceeded file size limit.");
                    break;
                default:
                    throw new \Exception("Unknown errors.");
            }
        }
    }
    public static function getHandlerToImportFile()
    {
        $path = \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("storage.path") . "/import";
        self::checkDirectory($path);
        $files = glob($path . "/*");
        foreach ($files as $file) {
            if(is_file($file)) {
                $tmp = explode(".", $file);
                $fileExtension = end($tmp);
                if(ContactImporter::getInstance()->isAllowedExtension($fileExtension)) {
                    return $file;
                }
            }
        }
        return false;
    }
}

?>