<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

/**
 * Class to maintain actions for single lead instance
 */
class MigrationHelper
{
    protected $flippedStatuses;
    protected $flippedFields;
    protected $logger;
    protected $oldLoggerLevel;
    protected function setNewLimits()
    {
        @ini_set("memory_limit", "512M");
        @ini_set("max_execution_time", 0);
        @set_time_limit(0);
    }
    protected function setUpDebugLogger()
    {
        $this->logger = \mgCRM2\Integration\Slim\SlimApp::getInstance()->log;
        $this->oldLoggerLevel = $this->logger->getLevel();
        $this->logger->setLevel(8);
    }
    protected function resolveDebugLogger()
    {
        $this->logger->setLevel($this->oldLoggerLevel);
    }
    public function getVersionOfLastCRM()
    {
        try {
            $query = \Illuminate\Database\Capsule\Manager::table("tbladdonmodules")->where("module", "=", "mgCRM")->where("setting", "=", "version")->first();
            return array_get((array) $query, "value", false);
        } catch (\Exception $ex) {
        }
        return false;
    }
    public function isOldCrmCompatibleToMigrate()
    {
        return "1.2.4" == $this->getVersionOfLastCRM();
    }
    public function getOverview()
    {
        $result = ["old_count_leads " => NULL, "auto_increment" => NULL];
        $result["lastVersion"] = $this->getVersionOfLastCRM();
        $result["compatible"] = $this->isOldCrmCompatibleToMigrate();
        try {
            $newLeadsTable = \Illuminate\Database\Capsule\Manager::selectOne(\Illuminate\Database\Capsule\Manager::connection()->raw("SHOW TABLE STATUS LIKE  'crm_resources'"));
            $newLeadsTable = (array) $newLeadsTable;
            if($newLeadsTable) {
                $result["auto_increment"] = intval($newLeadsTable->Auto_increment);
            }
            $result["old_count_leads"] = \Illuminate\Database\Capsule\Manager::table("mgCRM_leads")->count();
        } catch (\Exception $ex) {
        }
        return $result;
    }
    public function getOldVersionStatuses()
    {
        $fieldoptions = [];
        $query = \Illuminate\Database\Capsule\Manager::table("mgCRM_fields")->where("id", "=", 4)->first();
        $result = array_get((array) $query, "fieldoptions", false);
        if(!empty($result) && $query) {
            $decoded = json_decode($result, true);
            if(is_array($decoded)) {
                $fieldoptions[] = array_get($decoded, "default", []);
                $fieldoptions = array_merge($fieldoptions, array_get($decoded, "additional", []));
            }
        }
        return $fieldoptions;
    }
    public function getNewVersionStatuses()
    {
        return \mgCRM2\Models\FieldStatus::all()->toArray();
    }
    public function getOldVersionFields()
    {
        $fields = \Illuminate\Database\Capsule\Manager::table("mgCRM_fields")->select(["id", "fieldname", \Illuminate\Database\Capsule\Manager::raw("CONCAT('#', id, ' ', fieldname) as fullname"), "fieldtype", "description", "fieldoptions", "static", "sortorder"])->where("id", "!=", 4)->orderBy("sortorder", "ASC")->get();
        foreach ($fields as &$f) {
            $f = (array) $f;
            if($f["fieldtype"] == "dropdown") {
                $f["fieldoptions"] = explode(",", $f["fieldoptions"]);
            }
        }
        return $fields;
    }
    public function getNewVersionFields()
    {
        $dynamic = \mgCRM2\Models\Field::all();
        return ["dynamic" => $dynamic->toArray(), "static" => ["name", "email", "phone"]];
    }
    public function diffStatuses()
    {
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->select("status_id", \Illuminate\Database\Capsule\Manager::raw("count(*) as total"))->whereNull("deleted_at")->groupBy("status_id");
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($this->adminID)) {
            $query = $query->where("admin_id", "=", $this->adminID);
        }
        $leads = clone $query;
        $leads = $leads->where("is_potential", "=", 0);
        $potentials = clone $query;
        $potentials = $potentials->where("is_potential", "=", 1);
        $results = ["leads" => $leads->get(), "potentials" => $potentials->get()];
        return $results;
    }
    public function startMigration($data = [])
    {
        $this->setUpDebugLogger();
        $this->setNewLimits();
        $this->logger->info("---------------------------------------------------------------------------");
        $this->logger->info("---------------Migration Start");
        $mapStatuses = $this->getStatusesMapFromInput($data);
        $mapCustomFields = $this->getCustomFieldsMapFromInput($data);
        $availableFields = $this->getOnlyFieldsFromMapper($mapCustomFields);
        $leads = \Illuminate\Database\Capsule\Manager::table("mgCRM_leads")->get();
        $defuleTypeId = \mgCRM2\Models\ResourceType::first()->id;
        $defuleStatusId = \mgCRM2\Models\FieldStatus::first()->id;
        $this->logger->info("Found {num} records to migrate", ["num" => count($leads)]);
        $counter = 0;
        foreach ($leads as $lead) {
            $lead = (array) $lead;
            $relid = array_get($lead, "id");
            $this->logger->info("Start migrate record with ID:#{id}; from (`mgCRM_leads`)", ["id" => $relid]);
            try {
                $mappedCreateData = (array) $this->mapStaticData($lead);
                $oldLeadCustomFields = $this->getOldLeadCustoFields($relid);
                $oldLeadCustomFields = (array) $oldLeadCustomFields;
                $mappedCreateData["type_id"] = 1;
                $mappedCreateData = array_add($mappedCreateData, "name", array_get($oldLeadCustomFields, "1", NULL));
                $mappedCreateData = array_add($mappedCreateData, "email", array_get($oldLeadCustomFields, "2", NULL));
                $mappedCreateData = array_add($mappedCreateData, "phone", array_get($oldLeadCustomFields, "3", NULL));
                $status_id = array_get($mapStatuses, array_get($oldLeadCustomFields, "4", NULL), $defuleStatusId);
                if(!is_null($status_id)) {
                    $mappedCreateData = array_add($mappedCreateData, "status_id", $status_id);
                }
                $mappedCreateData = array_add($mappedCreateData, "type_id", $defuleTypeId);
                $newResource = new \mgCRM2\Models\Resource($mappedCreateData);
                $newResource->save();
                $this->logger->info("Migrating record from (`mgCRM_leads`) with ID:#{id}; new ID after migration: #{newid}", ["id" => $relid, "newid" => $newResource->id]);
                $this->logger->info("Migrating custom field values for ID:#{newid}", ["newid" => $newResource->id]);
                $fieldsData = $errors = [];
                foreach ($availableFields as $field) {
                    try {
                        $mappedSingleData = array_get($oldLeadCustomFields, array_get($mapCustomFields, $field->id, ""), NULL);
                        $fieldsData[] = $field->createNewDataFromMigrationData($newResource, $mappedSingleData);
                        $this->logger->info("Field {field} migrated", ["field" => sprintf("#%s %s", $field->id, $field->name)]);
                    } catch (\Exception $ex) {
                        $this->logger->error("Cant migrate custom field value: {error}", ["error" => $e->getMessage()]);
                    }
                }
                $this->logger->info("Migrating notes for #{newid}", ["newid" => $newResource->id]);
                try {
                    \Illuminate\Database\Capsule\Manager::statement(sprintf("\n                            INSERT INTO  `crm_notes` ( resource_id, admin_id, content, created_at, updated_at )\n                            SELECT  '%d', admin_id, TEXT, DATE, DATE\n                            FROM  `mgCRM_notes`\n                            WHERE relid = %d;\n                        ", $newResource->id, $relid));
                    \mgCRM2\Repositories\Notes::fixMigratedNotesHtmlCode($newResource->id);
                    $this->logger->info("Notes migrated for #{newid}", ["newid" => $newResource->id]);
                } catch (\Exception $ex) {
                    $this->logger->error("Cant migrate notes, query error: {error}", ["error" => $e->getMessage()]);
                }
                $this->logger->info("Fixing timestamps #{newid}", ["newid" => $newResource->id]);
                $this->fixTimestampsFor($newResource->id, $mappedCreateData);
                if($newResource->id) {
                    $counter++;
                    $this->logger->info("Record #{newid} succesfully migrated from old #{relid}", ["newid" => $newResource->id, "relid" => $relid]);
                    $this->logger->info("---------------");
                }
            } catch (\Exception $ex) {
                $this->logger->error("Error: {error}", ["error" => $e->getMessage()]);
            }
        }
        $this->logger->info("---------------Migrated records: {num}", ["num" => $counter]);
        $this->logger->info("---------------Migration Start");
        $this->logger->info("---------------------------------------------------------------------------");
        $this->resolveDebugLogger();
        return ["status" => "success", "logfile" => date("Y-m-d") . ".log", "msg" => sprintf("Migrated records: %s", $counter)];
    }
    public function getOnlyFieldsFromMapper($mapper)
    {
        $return = [];
        $all = \mgCRM2\Models\Field::joinOptions()->get();
        foreach ($all as $f) {
            if(array_key_exists($f->id, $mapper)) {
                $return[$f->id] = $f;
            }
        }
        return $return;
    }
    public function getCustomFieldsMapFromInput($data)
    {
        return array_get($data, "dynamic", []);
    }
    public function getStatusesMapFromInput($data)
    {
        $mapStatuses = array_get($data, "statuses", []);
        if(!empty($mapStatuses)) {
            $mapStatuses = array_flip($mapStatuses);
        }
        return $mapStatuses;
    }
    public function fixTimestampsFor($id, $data)
    {
        $fixTimestamps = ["created_at" => $data["created_at"]->toDateTimeString(), "updated_at" => $data["updated_at"]->toDateTimeString()];
        if($data["deleted_at"] instanceof \Carbon\Carbon) {
            $fixTimestamps["deleted_at"] = $data["deleted_at"]->toDateTimeString();
        }
        \Illuminate\Database\Capsule\Manager::table("crm_resources")->where("id", "=", $id)->update($fixTimestamps);
    }
    public function getOldLeadCustoFields($id)
    {
        $return = [];
        $fields = \Illuminate\Database\Capsule\Manager::table("mgCRM_fieldsvalues")->where("relid", "=", $id)->get();
        foreach ($fields as $f) {
            $f = (array) $f;
            $return[$f["fieldid"]] = $f["value"];
        }
        return $return;
    }
    public function mapStaticData($data = [])
    {
        $updated = \Carbon\Carbon::parse(array_get($data, "update_date", false));
        $created = \Carbon\Carbon::parse(array_get($data, "creation_date", false));
        $deleted = NULL;
        $type_id = 1;
        if(array_get($data, "type") == "potential") {
            $type_id = 2;
        } elseif(array_get($data, "type") == "archive") {
            $deleted = clone $updated;
        }
        $client_id = array_get($data, "client_id", NULL);
        if(!is_numeric($client_id) || $client_id == 0) {
            $client_id = NULL;
        }
        $ticket_id = array_get($data, "ticket_id", NULL);
        if(!is_numeric($ticket_id) || $ticket_id == 0) {
            $ticket_id = NULL;
        }
        $admin_id = array_get($data, "admin_id", NULL);
        if(!is_numeric($admin_id) || $admin_id == 0) {
            $admin_id = NULL;
        }
        $return = ["client_id" => $client_id, "ticket_id" => $ticket_id, "admin_id" => $admin_id, "is_potential" => $type_id, "created_at" => $created, "updated_at" => $updated, "deleted_at" => $deleted];
        return $return;
    }
}

?>