<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Class to maintain actions for single lead instance
 */
class StatisticsBuilder
{
    protected $adminID = false;
    public function __construct($adminID)
    {
        $this->adminID = $adminID;
    }
    public function getResourcesPerStatus($data)
    {
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->select("status_id", "type_id", \Illuminate\Database\Capsule\Manager::raw("count(*) as total"))->whereNull("deleted_at")->groupBy("status_id")->groupBy("type_id");
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($this->adminID)) {
            $query = $query->where("admin_id", "=", $this->adminID);
        }
        $return = [];
        $types = \mgCRM2\Models\ResourceType::orderred()->onlyActive()->get();
        $result = $query->get();
        foreach ($types as $type) {
            if($type->isActive()) {
                $tmp = ["type" => $type->toArray(), "data" => []];
                foreach ($result as $r) {
                    $r = (array) $r;
                    if($type->id == (int) $r["type_id"]) {
                        $r["total"] = intval($r["total"]);
                        $r["status_id"] = intval($r["status_id"]);
                        $tmp["data"][] = $r;
                    }
                }
                $return[] = $tmp;
            }
        }
        return $return;
    }
    public function getLastTenRecords($data)
    {
        $query = \mgCRM2\Models\Resource::whereNull("deleted_at")->orderBy("created_at", "desc")->with(["admin" => function ($query) {
            $query->select("id", "roleid", "username", "firstname", "lastname", "email");
        }])->with("status")->limit(10);
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($this->adminID)) {
            $query = $query->where("admin_id", "=", $this->adminID);
        }
        $return = [];
        $types = \mgCRM2\Models\ResourceType::orderred()->onlyActive()->get();
        foreach ($types as $type) {
            if($type->isActive()) {
                $tmpQuery = clone $query;
                $tmp = ["type" => $type->toArray(), "data" => $tmpQuery->where("type_id", "=", $type->id)->get()->toArray()];
                unset($tmpQuery);
                $return[] = $tmp;
            }
        }
        return $return;
    }
    public function getTotalRecordsPerAdmin($data, $where = [])
    {
        $admins = \Illuminate\Database\Capsule\Manager::table("tbladmins")->select("id", "firstname", "lastname")->where($where)->get();
        $return = [];
        $types = \mgCRM2\Models\ResourceType::orderred()->onlyActive()->get();
        foreach ($types as $type) {
            if($type->isActive()) {
                $tmp = ["type" => $type->toArray(), "data" => []];
                foreach ($admins as &$admin) {
                    $admin = (array) $admin;
                    if($type->isActive()) {
                        $count = (array) \Illuminate\Database\Capsule\Manager::table("crm_resources")->select(\Illuminate\Database\Capsule\Manager::raw("count(*) as total"))->whereNull("deleted_at")->where("admin_id", "=", $admin["id"])->where("type_id", "=", $type->id)->first();
                        $tmp["data"][] = intval($count["total"]);
                    }
                }
                $return[] = $tmp;
            }
        }
        return array_merge(["types" => $return], ["admins" => $admins]);
    }
    public function getTotalRecordsPerYear($year, $data)
    {
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->select(\Illuminate\Database\Capsule\Manager::raw("count(*) as total"), \Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%c') as month"))->whereNull("deleted_at")->where(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%Y')"), "=", $year)->groupBy(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%c')"));
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($this->adminID)) {
            $query = $query->where("admin_id", "=", $this->adminID);
        }
        $return = [];
        $types = \mgCRM2\Models\ResourceType::orderred()->onlyActive()->get();
        foreach ($types as $type) {
            if($type->isActive()) {
                $tmp = ["type" => $type->toArray(), "month" => []];
                $tmpQuery = clone $query;
                $months = $tmpQuery->where("type_id", "=", $type->id)->get();
                for ($i = 0; $i < 12; $i++) {
                    array_set($tmp, "month." . $i, array_get($tmp, "month." . $i, 0));
                }
                foreach ($months as $l) {
                    $l = (array) $l;
                    array_set($tmp, "month." . intval(--$l["month"]), intval($l["total"]));
                }
                unset($tmpQuery);
                $return[] = $tmp;
            }
        }
        return $return;
    }
    public function getTotalRecordsInMonth($year, $month, $data)
    {
        $query = \Illuminate\Database\Capsule\Manager::table("crm_resources")->select(\Illuminate\Database\Capsule\Manager::raw("count(*) as total"), \Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%d') as day"))->whereNull("deleted_at")->where(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%Y')"), "=", $year)->where(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%c')"), "=", $month)->groupBy(\Illuminate\Database\Capsule\Manager::raw("DATE_FORMAT(created_at, '%d')"));
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($this->adminID)) {
            $query = $query->where("admin_id", "=", $this->adminID);
        }
        $return = [];
        $types = \mgCRM2\Models\ResourceType::orderred()->onlyActive()->get();
        $dt = \Carbon\Carbon::parse($year . "-" . $month);
        foreach ($types as $type) {
            if($type->isActive()) {
                $tmp = ["type" => $type->toArray(), "month" => []];
                $tmpQuery = clone $query;
                $days = $tmpQuery->where("type_id", "=", $type->id)->get();
                for ($i = 0; $i < $dt->daysInMonth; $i++) {
                    array_set($tmp, "month." . $i, 0);
                }
                foreach ($days as $l) {
                    $l = (array) $l;
                    array_set($tmp, "month." . intval(--$l["day"]), intval($l["total"]));
                }
                unset($tmpQuery);
                $return[] = $tmp;
            }
        }
        return $return;
    }
}

?>