<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

/**
 * Class to maintain actions for single lead instance
 */
class TablesFieldViews
{
    protected static $staticFields = ["lists.leads" => "lists.leads", "lists.potentials" => "lists.potentials", "dashboard" => "dashboard"];
    protected static $namesMap = ["lists.leads" => "lists.leads", "lists.potentials" => "lists.potentials", "dashboard" => "dashboard"];
    public static function allColumns()
    {
        $fields = \mgCRM2\Models\Field::all();
        $staticFields = \mgCRM2\Models\Resource::getStaticFields();
        $available = ["fields" => $fields->toArray(), "static" => $staticFields];
        return $available;
    }
    public static function getAllColumnsForFilters()
    {
        $fields = \mgCRM2\Models\FieldGroup::with(["fields" => function ($query) {
            $query->whereActive()->joinOptions()->orderBy("order", "asc");
        }])->orderBy("order", "asc")->get();
        $staticFields = [];
        foreach (\mgCRM2\Models\Resource::getStaticFields() as $f) {
            $tmp = ["id" => $f, "type" => "text", "name" => \mgCRM2\Services\Language::translate("campaigns.filters.static." . $f)];
            if(!in_array($f, ["id", "admin", "client", "ticket"])) {
                if($f == "status") {
                    $tmp["type"] = "select";
                    $tmp["options"] = \mgCRM2\Models\FieldStatus::all()->toArray();
                } elseif($f == "priority") {
                    $tmp["type"] = "select";
                    $tmp["options"] = [["id" => 1, "name" => \mgCRM2\Services\Language::translate("priority.low")], ["id" => 2, "name" => \mgCRM2\Services\Language::translate("priority.medium")], ["id" => 3, "name" => \mgCRM2\Services\Language::translate("priority.important")], ["id" => 4, "name" => \mgCRM2\Services\Language::translate("priority.urgent")]];
                } elseif($f == "country") {
                    $tmp["type"] = "select";
                    $countryFile = get_coutry_dir();
                    $country = [];
                    if($countryFile["type"] === "json") {
                        foreach (object_to_array(json_decode(file_get_contents($countryFile["dir"]), true)) as $key => $value) {
                            $value["id"] = $key;
                            $country[] = $value;
                        }
                    } else {
                        require_once $countryFile["dir"];
                        foreach ($countries as $key => $value) {
                            $country[] = ["id" => $key, "name" => $value];
                        }
                    }
                    $tmp["options"] = $country;
                } elseif($f == "labels") {
                    $tmp["type"] = "select";
                    $tmp["options"] = \mgCRM2\Models\Label::all();
                }
                $staticFields[] = $tmp;
            }
        }
        $contactTypes = [];
        foreach (\mgCRM2\Models\ResourceType::orderred()->onlyActive()->pluck("name", "id") as $id => $name) {
            $contactTypes[] = ["id" => $id, "name" => $name];
        }
        $staticFields[] = ["id" => "type_id", "type" => "select", "name" => \mgCRM2\Services\Language::translate("campaigns.filters.static.type"), "options" => $contactTypes];
        $available = ["dynamic" => $fields->toArray(), "static" => $staticFields];
        return $available;
    }
    public static function getAllColumnsWithOptions()
    {
        $fields = \mgCRM2\Models\FieldGroup::with(["fields" => function ($query) {
            $query->whereActive()->joinOptions()->orderBy("order", "asc");
        }])->orderBy("order", "asc")->get();
        $staticFields = [];
        foreach (\mgCRM2\Models\Resource::getStaticFields() as $f) {
            $tmp = ["id" => $f, "type" => "text", "name" => \mgCRM2\Services\Language::translate("campaigns.filters.static." . $f), "isStatic" => true];
            if(!in_array($f, ["id", "admin", "client", "ticket"])) {
                if($f == "status") {
                    $tmp["type"] = "select";
                    $tmp["options"] = \mgCRM2\Models\FieldStatus::all()->toArray();
                    foreach ($tmp["options"] as &$option) {
                        $option["value"] = $option["name"];
                    }
                } elseif($f == "priority") {
                    $tmp["type"] = "select";
                    $tmp["options"] = [["id" => 1, "value" => \mgCRM2\Services\Language::translate("priority.low")], ["id" => 2, "value" => \mgCRM2\Services\Language::translate("priority.medium")], ["id" => 3, "value" => \mgCRM2\Services\Language::translate("priority.important")], ["id" => 4, "value" => \mgCRM2\Services\Language::translate("priority.urgent")]];
                } elseif($f == "country") {
                    $tmp["type"] = "select";
                    $countryFile = get_coutry_dir();
                    $country = [];
                    if($countryFile["type"] === "json") {
                        foreach (object_to_array(json_decode(file_get_contents($countryFile["dir"]), true)) as $key => $value) {
                            $value["id"] = $key;
                            $value["value"] = $value["name"];
                            $country[] = $value;
                        }
                    } else {
                        require_once $countryFile["dir"];
                        foreach ($countries as $key => $value) {
                            $country[] = ["id" => $key, "value" => $value];
                        }
                    }
                    $tmp["options"] = $country;
                } elseif($f == "labels") {
                    $tmp["type"] = "select";
                    $labelOptions = [];
                    foreach (\mgCRM2\Models\Label::all() as $label) {
                        $labelOptions[] = ["id" => $label->id, "value" => $label->name];
                    }
                    $tmp["options"] = $labelOptions;
                }
                $staticFields[] = $tmp;
            }
        }
        $contactTypes = [];
        foreach (\mgCRM2\Models\ResourceType::orderred()->onlyActive()->pluck("name", "id") as $id => $name) {
            $contactTypes[] = ["id" => $id, "value" => $name];
        }
        $staticFields[] = ["id" => "type_id", "type" => "select", "name" => \mgCRM2\Services\Language::translate("campaigns.filters.static.type"), "options" => $contactTypes, "isStatic" => true];
        foreach ($fields as $group) {
            foreach ($group->fields as $field) {
                $staticFields[] = array_merge($field->toArray(), ["isStatic" => false]);
            }
        }
        return $staticFields;
    }
    public static function defaults()
    {
        $staticFields = \mgCRM2\Models\Resource::getStaticFields();
        $available = $staticFields;
        return $available;
    }
    public static function allForAdmin()
    {
        $settings = [];
        foreach (self::$namesMap as $ruleKey => $ruleName) {
            $settings[$ruleKey] = self::getSingleForAdmin($ruleName);
        }
        return $settings;
    }
    public static function getSingleForAdmin($rule)
    {
        if(!in_array($rule, self::$namesMap)) {
            throw new \Exception("Invalid rule");
        }
        $adminID = \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id;
        $setting = \mgCRM2\Models\Setting::where("admin_id", "=", $adminID)->where("name", "=", $rule)->first();
        if(!$setting || is_null($setting->value) || $setting->value == "null") {
            return self::defaults();
        }
        $toReturn = $fieldIDs = [];
        foreach ($setting->value as $v) {
            $toReturn[] = $v;
            if(!is_string($v)) {
                if(is_array($v) && array_get($v, "id", NULL) != NULL) {
                    $fieldIDs[] = $v["id"];
                }
            }
        }
        if(!empty($fieldIDs)) {
            $list = \mgCRM2\Models\Field::whereIn("id", $fieldIDs)->joinOptions()->get()->toArray();
            $list = array_flip_keys_by($list, "id");
            foreach ($toReturn as $k => $v) {
                if(is_array($v) && array_get($v, "id", NULL) != NULL) {
                    $toReturn[$k] = array_get($list, $v["id"]);
                }
            }
        }
        return $toReturn;
    }
    public static function updateForAdmin($rule, $data)
    {
        $adminID = \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id;
        $data2 = self::filterGotFieldsForSave($data);
        $setting = \mgCRM2\Models\Setting::where("admin_id", "=", $adminID)->where("name", "=", $rule)->first();
        if(!$setting) {
            $setting = new \mgCRM2\Models\Setting();
            $setting->admin_id = $adminID;
            $setting->name = $rule;
            $setting->value = $data;
        }
        $setting->value = $data;
        return $setting->save();
    }
    public static function filterGotFieldsForSave($data)
    {
        return array_map(function ($k) {
            return is_array($k) ? $k["id"] : $k;
        }, $data);
    }
}

?>