<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Integration\WHMCSVersioning;

/**
 * Just determinate in various way what version of whmcs
 * we are currently use
 *
 * and perform right handler
 */
class Handler
{
    /**
     * Just container
     *
     * @var instance of WHMCS integration class
     */
    protected $integrationInstance;
    /**
     * Contain actial WHMCS version for use
     *
     * @var string
     */
    protected $version;
    public function __construct()
    {
        $this->determinateWhmcs();
    }
    protected function determinateWhmcs()
    {
        global $whmcs;
        if(!is_object($whmcs)) {
            $this->version = false;
            $this->integrationInstance = new Standalone();
        } else {
            if(is_callable([$whmcs, "getVersion"])) {
                $version = $whmcs->getVersion();
            } elseif(isset($GLOBALS["CONFIG"]["Version"])) {
                $version = $GLOBALS["CONFIG"]["Version"];
            } else {
                throw new \Exception("Onable to determinate WHMCS version");
            }
            if(!is_callable([$version, "getRelease"])) {
                throw new \Exception("WHMCS Version object dont have getRelease method");
            }
            $this->version = $version->getRelease();
            $class = "mgCRM2\\Integration\\WHMCSVersioning\\";
            if(version_compare($this->version, "5.2.0", ">=") && version_compare($this->version, "6.0.0", "<")) {
                $class .= "WHMCSv5";
            } elseif(version_compare($this->version, "6.0.0", ">=")) {
                $class .= "WHMCSv6";
            } else {
                throw new \Exception("Invalid WHMCS version or integration handler");
            }
            $this->integrationInstance = new $class($this->version);
        }
    }
    public function getInstance()
    {
        return $this->integrationInstance;
    }
    public function recheckForWhmcs()
    {
        $this->determinateWhmcs();
    }
    public function __call($name, $arguments)
    {
        if(!is_callable([$this->integrationInstance, $name])) {
            throw new \Exception("WHMCS Version integration interface method not found");
        }
        return $this->integrationInstance->{$name}();
    }
    public function getConfig($key, $default = "")
    {
        return $this->integrationInstance->getConfig($key, $default);
    }
    public function getAdminLang($key, $default = "")
    {
        return $this->integrationInstance->getAdminLang($key, $default);
    }
    public function getLang($key, $default = "")
    {
        return $this->integrationInstance->getLang($key, $default);
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function isVersion6()
    {
        return version_compare($this->version, "6.0.0", ">=");
    }
    public function isVersion78()
    {
        return version_compare($this->version, "7.8.0", ">=");
    }
    public function setUpCorrectSession()
    {
        if($this->version === false) {
            $this->getInstance()->setUpCorrectSession();
        }
    }
    public function getDownloadsDir()
    {
        $dir = $this->integrationInstance->getDownloadsDir();
        if(substr($dir, -1) != "/") {
            $dir .= "/";
        }
        if(file_exists(ROOTDIR . "/" . $dir)) {
            return ROOTDIR . "/" . $dir;
        }
        if(file_exists($dir)) {
            return $dir;
        }
        return $this->integrationInstance->getDownloadsDir();
    }
    public function getSystemUrl()
    {
        $systemUrlQuery = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "SystemURL")->select("value")->first();
        $systemUrl = array_get((array) $systemUrlQuery, "value", false);
        if(substr($systemUrl, strlen($systemUrl) - 1, 1) != "/") {
            $systemUrl .= "/";
        }
        return $systemUrl;
    }
    public function getSystemSslUrl()
    {
        $systemUrlQuery = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "SystemSSLURL")->select("value")->first();
        $systemUrl = array_get((array) $systemUrlQuery, "value", false);
        if(substr($systemUrl, strlen($systemUrl) - 1, 1) != "/") {
            $systemUrl .= "/";
        }
        return $systemUrl;
    }
    public function getAdminNameForAPIcall()
    {
        $admin = \Illuminate\Database\Capsule\Manager::table("tbladmins")->select("username")->take(1)->where("disabled", "=", "0")->orderBy("roleid", "ASC")->first();
        return $admin->username;
    }
}

?>