<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Integration\WHMCSVersioning;

class Standalone implements VersioningInterface
{
    /**
     * data gathered from WHMCS
     *
     * @var array
     */
    protected $data = [];
    public function __construct()
    {
        require ROOTDIR . "/configuration.php";
        $data = [];
        $data["db_host"] = $db_host;
        $data["db_name"] = $db_name;
        $data["db_username"] = $db_username;
        $data["db_password"] = $db_password;
        $data["db_port"] = isset($db_port) ? $db_port : NULL;
        $data["db_charset"] = !empty($mysql_charset) ? $mysql_charset : "utf8";
        $data["downloadsDir"] = !empty($downloads_dir) ? $downloads_dir : "downloads/";
        $data["attachmentsDir"] = !empty($attachments_dir) ? $attachments_dir : "attachments/";
        $data["templatesCompiled"] = !empty($templates_compiledir) ? $templates_compiledir : "templates_c/";
        $data["CCencryptionHash"] = $cc_encryption_hash;
        $data["adminCustomPath"] = !empty($customadminpath) ? $customadminpath : "admin";
        $data["adminID"] = $_SESSION["adminid"];
        $this->data = $data;
    }
    public function setUpCorrectSession()
    {
        if(version_compare(phpversion(), "5.4.0", ">=")) {
            if(session_status() == PHP_SESSION_NONE) {
                $this->_setUpCorrectSession();
            }
        } elseif(session_id() == "") {
            $this->_setUpCorrectSession();
        }
    }
    private function _setUpCorrectSession()
    {
        $sessionName = "";
        $results = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->select("value")->where("setting", "=", "InstanceID")->get();
        $results = end($results);
        if(!empty($results->value) && is_string($results->value)) {
            $sessionName = $results->value;
        } else {
            $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVYWXYZ0123456789";
            $count = strlen($chars) - 1;
            $i = 0;
            for ($i = 0; $i < 12; $i++) {
                $sessionName .= $chars[rand(0, $count)];
            }
            \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "InstanceID")->update(["value" => $sessionName]);
        }
        session_name("WHMCS" . $sessionName);
        session_set_cookie_params(0, "/", NULL, false, true);
        session_start();
    }
    public function getWHMCSinitObject()
    {
        return false;
    }
    public function getWHMCSadminObject()
    {
        return false;
    }
    public function getConfig($key, $default = "")
    {
        return false;
    }
    public function getAdminLang($key, $default = "")
    {
        return false;
    }
    public function getLang($key, $default = "")
    {
        return false;
    }
    public function getAdminLanguage()
    {
        return false;
    }
    public function getAdminTemplate()
    {
        return false;
    }
    public function getAdminID()
    {
        return array_get($this->data, "adminID", NULL);
    }
    public function isAdminLoggedIn()
    {
        return isset($this->data["adminID"]);
    }
    public function getAdminCustomPath()
    {
        return array_get($this->data, "adminCustomPath", NULL);
    }
    public function getMysqlConnection()
    {
        return false;
    }
    public function getAttachmentsDir()
    {
        return array_get($this->data, "attachmentsDir", NULL);
    }
    public function getDownloadsDir()
    {
        return array_get($this->data, "downloadsDir", NULL);
    }
    public function getTemplatesCompiledDir()
    {
        return array_get($this->data, "templatesCompiled", NULL);
    }
    public function getCCencryptionHash()
    {
        return array_get($this->data, "CCencryptionHash", NULL);
    }
    public function getDBhost()
    {
        return array_get($this->data, "db_host", "");
    }
    public function getDBname()
    {
        return array_get($this->data, "db_name", "");
    }
    public function getDBport()
    {
        return array_get($this->data, "db_port", NULL);
    }
    public function getDBusername()
    {
        return array_get($this->data, "db_username", "");
    }
    public function getDBpassword()
    {
        return array_get($this->data, "db_password", "");
    }
    public function getDBcharset()
    {
        return array_get($this->data, "db_charset", "utf8");
    }
}

?>