<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for lead/potential
 */
class AutomationRules extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_automations_rules";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = [];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["automation_id", "parent_id", "rule", "data", "order", "rules"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public function getDataAttribute($value)
    {
        return json_decode($value);
    }
    public function setDataAttribute($value)
    {
        $this->attributes["data"] = json_encode($value);
        return $this;
    }
    public function automation()
    {
        return $this->belongsTo("mgCRM2\\Models\\Automations", "automation_id");
    }
    public function rules()
    {
        return $this->hasMany("mgCRM2\\Models\\AutomationRules", "parent_id", "id")->with("rules")->orderBy("order", "asc");
    }
    public static function checkIfRuleIsUsed($rule)
    {
        return self::with("automation")->where("rule", $rule)->whereHas("automation", function ($query) {
            $query->whereNull("deleted_at")->where("status", 1);
        })->first();
    }
}

?>