<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

class AddContactReminderRule extends AddReminderRule
{
    protected $rule;
    protected $resultData;
    protected $customParams;
    protected $fields = ["type", "template_id"];
    public function validateField()
    {
        foreach ($this->fields as $field) {
            if(!isset($this->rule->data->{$field}) || empty($this->rule->data->{$field})) {
                return false;
            }
        }
        return true;
    }
    public function send($smartyVariables, $resource)
    {
        $method = $this->rule->data->type;
        $templateId = $this->rule->data->template_id;
        $dataString = "contact_email:" . $resource->email . ",recource_id:" . $resource->id . ",method:" . $method . ",template_id:" . $templateId;
        if($this->checkIsSend($dataString)) {
            return $this;
        }
        if($method === "sms") {
            $this->sentSmsReminder($templateId, $resource, NULL, $smartyVariables, $dataString);
        } else {
            $this->sentEmailReminder($templateId, $resource, $resource->admin, $smartyVariables, $dataString);
        }
        return $this;
    }
    protected function sentEmailReminder($templateId, $resource, $admin, $smartyVariables, $dataString)
    {
        $recipients = [];
        $cc = [];
        $replyTo = [];
        $targetEmail = $resource->getEmailForReminder();
        $recipients[] = $targetEmail;
        if(!\mgCRM2\Models\Validators\Common::isValidEmail($targetEmail)) {
            return $this;
        }
        if($admin) {
            if(\mgCRM2\Models\Validators\Common::isValidEmail($admin->email)) {
                $cc[] = ["email" => $admin->email, "name" => $admin->full];
            }
            $replyTo = ["email" => $admin->email, "name" => $admin->full];
        }
        $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
        $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($resource->id);
        array_set($smartyVariables, "contact", $resource->toArray());
        $smartyVariables["contact"]["fields"] = $fieldsData;
        if($resource->client->id) {
            array_set($smartyVariables, "contact.client", $resource->client->markAllColumnsVisible()->toArray());
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $mailer = mgCRM_getMailerInstance();
        $result = $mailer->sentReminderEmailFromTemplate($templateId, $recipients, $replyTo, $cc, $smartyVariables, ["resource_id" => $resource->id, "followup_id" => NULL, "reminder_id" => NULL]);
        if($result) {
            $this->addAutomationRuleExcecute($dataString);
            $this->status = "sent";
        } else {
            $this->status = "error";
        }
        return $result;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    public function setResultData($resultData)
    {
        $this->resultData = $resultData;
        return $this;
    }
    public function getRule()
    {
        return $this->rule;
    }
    public function setRule($rule)
    {
        $this->rule = $rule;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setCustomParams($customParams)
    {
        $this->customParams = $customParams;
        return $this;
    }
}

?>