<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

/**
 * Description of AddReminderRule
 *
 * @author Rafał
 */
class AddReminderRule implements RuleInterface
{
    /**
     * @var \mgCRM2\Models\AutomationRules 
     */
    protected $rule;
    protected $resultData;
    protected $fields = ["type", "target_id", "template_id"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        foreach ($this->resultData as $recource) {
            $this->send($this->getSendData($recource->id), $recource);
        }
        return $this;
    }
    protected function getSendData($recourceId)
    {
        return isset($this->customParams[$recourceId]) ? $this->customParams[$recourceId] : [];
    }
    public function validateRule()
    {
        return true;
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    protected function send($smartyVariables, $recource)
    {
        $method = $this->rule->data->type;
        $admin = \mgCRM2\Models\Whmcs\Admin::where("id", $this->rule->data->target_id)->first();
        $templateId = $this->rule->data->template_id;
        $dataString = "admin_id:" . $this->rule->data->target_id . ",recource_id:" . $recource->id . ",method:" . $method . ",template_id:" . $templateId;
        if($this->checkIsSend($dataString)) {
            return $this;
        }
        if($method == "sms") {
            $this->sentSmsReminder($templateId, $recource, $admin, $smartyVariables, $dataString);
        } else {
            $this->sentEmailReminder($templateId, $recource, $admin, $smartyVariables, $dataString);
        }
        return $this;
    }
    protected function sentSmsReminder($templateId, $recource, $admin, array $smartyVariables = [], $dataString = "")
    {
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        array_set($smartyVariables, "contact", $recource->toArray());
        array_add($smartyVariables["contact"], "fields", (new \mgCRM2\Repositories\FieldDatas())->getOnlyFieldsForResourceSummary($recource->id));
        $getMergeFields = $smartyVariables["contact"];
        foreach ($getMergeFields as $key => $value) {
            if(!strpos($key, "_")) {
                $getMergeFields["client_" . $key] = $value;
                unset($getMergeFields[$key]);
            }
            if(isset($getMergeFields["client_phone"])) {
                $getMergeFields["client_phonenumber"] = $value;
                unset($getMergeFields["client_phone"]);
            }
        }
        if($recource->client->id) {
            array_set($smartyVariables, "contact.client", $recource->client->markAllColumnsVisible()->toArray());
            $bootstrapSmsCenter = ROOTDIR . DIRECTORY_SEPARATOR . "modules" . DIRECTORY_SEPARATOR . "addons" . DIRECTORY_SEPARATOR . "sms_center" . DIRECTORY_SEPARATOR . "Bootstrap.php";
            if(class_exists("\\ModulesGarden\\SmsCenter\\App\\Helper\\SmartyHelper\\Client") === false && file_exists($bootstrapSmsCenter)) {
                require_once $bootstrapSmsCenter;
            }
            $getMergeFields = (new \ModulesGarden\SmsCenter\App\Helper\SmartyHelper\Client($recource->client->id))->getMergeFields();
        }
        $sender = mgCRM_getSenderSmsInstance();
        $smartyVariables = array_merge($smartyVariables, $getMergeFields);
        if(!$smartyVariables["contact"]["phone"] && $smartyVariables["contact"]["client"]) {
            $sms_number = str_replace(" ", "", \Illuminate\Database\Capsule\Manager::select("SELECT tblcustomfieldsvalues.value FROM `tblcustomfieldsvalues`\n                                     join crm_resources\n                                     on tblcustomfieldsvalues.relid = crm_resources.client_id\n                                     join tblcustomfields\n                                     on tblcustomfields.id = tblcustomfieldsvalues.fieldid\n                                     where tblcustomfields.fieldname LIKE \"%sms_number%\"\n                                     AND  crm_resources.id = " . $recource->id)[0]["value"]);
        }
        $adminPhoneNumber = \Illuminate\Database\Capsule\Manager::select("SELECT mobile FROM SmsCenter_AdminNotifications WHERE aid = :aid", ["aid" => $admin->id]);
        list($template) = \Illuminate\Database\Capsule\Manager::select("SELECT template.message\n                             FROM `SmsCenter_Templates` template\n                             join SmsCenter_MessageGroups `group`\n                             on template.group_id=group.id\n                             join tblemailtemplates emailtemplate\n                             on group.msg_name=emailtemplate.name\n                             where emailtemplate.id = " . $templateId . " ORDER BY `emailtemplate`.`id` ASC");
        $smarty = $sender::makeSmartyObject();
        $smarty->assign($smartyVariables);
        $params = ["phonenumber" => $adminPhoneNumber[0]->mobile ?? $recource->phone, "message" => trim($sender::smartyStringFetch($smarty, $template->message))];
        $adminName = \mgCRM2\Integration\Slim\SlimApp::getInstance()->whmcs->getAdminNameForAPIcall();
        $result = localAPI("sendsms", $params, $adminName);
        if($result["result"] != "error") {
            $this->addAutomationRuleExcecute($dataString);
            $return = true;
        } else {
            $this->status = "error";
            $return = false;
        }
        return $return;
    }
    protected function sentEmailReminder($templateId, $recource, $admin, $smartyVariables, $dataString)
    {
        $recipients = [];
        $cc = [];
        $replyTo = [];
        $emailTemplate = $templateId;
        $targetEmail = $admin->email;
        if(!\mgCRM2\Models\Validators\Common::isValidEmail($targetEmail)) {
            return $this;
        }
        $recipients[] = $targetEmail;
        if(!is_null($admin) && \mgCRM2\Models\Validators\Common::isValidEmail($admin->email)) {
            $cc[] = ["email" => $admin->email, "name" => $admin->full];
        }
        if(!is_null($admin)) {
            $replyTo = ["email" => $admin->email, "name" => $admin->full];
        }
        $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
        $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($recource->id);
        array_set($smartyVariables, "contact", $recource->toArray());
        $smartyVariables["contact"]["fields"] = $fieldsData;
        if($recource->client->id) {
            array_set($smartyVariables, "contact.client", $recource->client->markAllColumnsVisible()->toArray());
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $mailer = mgCRM_getMailerInstance();
        $result = $mailer->sentReminderEmailFromTemplate($emailTemplate, $recipients, $replyTo, $cc, $smartyVariables, ["resource_id" => $recource->id, "followup_id" => NULL, "reminder_id" => NULL]);
        if($result) {
            $this->addAutomationRuleExcecute($dataString);
            $this->status = "sent";
        } else {
            $this->status = "error";
        }
        return $result;
    }
    protected function checkIsSend($checkData)
    {
        return 0 < \mgCRM2\Models\AutomationRulesExcecute::whereRule("addReminder")->whereNow()->whereData($checkData)->whereRuleId($this->rule->id)->count();
    }
    protected function addAutomationRuleExcecute($checkData)
    {
        return (new \mgCRM2\Models\AutomationRulesExcecute(["rule" => "addReminder", "rule_id" => $this->rule->id, "data" => $checkData, "date" => \Carbon\Carbon::now()]))->save();
    }
}

?>