<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

class ConditionIfChangeAdminRule implements RuleInterface
{
    protected $rule;
    protected $resultData;
    protected $fields;
    protected $customParams;
    const ADMIN_ID_FIELD = "admin_id";
    const AFTER_DAYS_FIELD = "after";
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
            if($field == self::ADMIN_ID_FIELD) {
                $isSuccess = $this->adminExists($data->{$field});
            }
        }
    }
    public function validateRule()
    {
        $adminId = $this->rule->data->admin_id;
        $afterDays = $this->rule->data->after;
        $resourceIds = array_map(function ($resource) {
            return $resource["id"];
        }, $this->resultData->toArray());
        $logs = \mgCRM2\Models\Log::whereIn("resource_id", $resourceIds)->where("event", "LIKE", "Admin Reassign")->where("message", "LIKE", "%" . $adminId . "%")->whereRaw("DATE(`date`) LIKE DATE(NOW() - INTERVAL ? DAY)", [$afterDays])->orderBy("date", "ASC");
        $resourceIds = $this->executeLogs($logs);
        $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
            return in_array($resource->id, $resourceIds);
        });
        return 0 < $this->resultData->count();
    }
    public function execute()
    {
        return $this;
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    protected function adminExists($adminId)
    {
        $admin = \mgCRM2\Models\Whmcs\Admin::find($adminId);
        return $admin->exists;
    }
    protected function executeLogs($query)
    {
        $resourceIds = [];
        foreach ($query->get() as $log) {
            $resourceIds[] = $log->resource_id;
        }
        return $resourceIds;
    }
}

?>