<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

/**
 * Description of ConditionIfRule
 *
 * @author Rafał
 */
class ConditionIfChangeRule implements RuleInterface
{
    /**
     * @var \mgCRM2\Models\AutomationRules 
     */
    protected $rule;
    protected $resultData;
    protected $fields = ["field", "value"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        return $this;
    }
    public function validateRule()
    {
        $field = $this->rule->data->field;
        $value = $this->rule->data->value;
        $onlyToDay = $this->rule->data->onlyToDay;
        if(is_numeric($field)) {
            $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
                if(0 < count($resource->fieldDatasWithAll)) {
                    $fieldIndex = array_search($field . "id", array_map(function ($e) {
                        return is_object($e) ? $e->field_id . "id" : $e["field_id"] . "id";
                    }, $resource->fieldDatasWithAll->toArray()), true);
                    if($fieldIndex !== false) {
                        $isLastChange = false;
                        $type = $resource->fieldDatasWithAll[$fieldIndex]->field_type;
                        $options = $resource->fieldDatasWithAll[$fieldIndex]->options;
                        $data = $resource->fieldDatasWithAll[$fieldIndex]->data;
                        if(0 < count($resource->logs->filter(function ($log) use($log) {
                            if($onlyToDay === true && $log->date->isToday() === false) {
                                return false;
                            }
                            if($log->event == "Field Update" && strpos($log->message, " #" . $field . " ") !== false) {
                                switch ($type) {
                                    case "radio":
                                    case "select":
                                        $isLastChange = 0 < count($options) && array_search($value . "id", array_map(function ($e) {
                                            return is_object($e) ? $e->option_id . "id" : $e["option_id"] . "id";
                                        }, $options->toArray())) !== false;
                                        $isLastChange = $isLastChange !== false ? strpos($log->message, $options[0]->option->value) !== false : $isLastChange;
                                        break;
                                    default:
                                        $isLastChange = strpos($log->message, $value) !== false;
                                        return true;
                                }
                            } else {
                                return false;
                            }
                        }))) {
                            switch ($type) {
                                case "radio":
                                case "select":
                                    return $isLastChange && 0 < count($options) && array_search($value . "id", array_map(function ($e) {
                                        return is_object($e) ? $e->option_id . "id" : $e["option_id"] . "id";
                                    }, $options->toArray())) !== false;
                                    break;
                                default:
                                    return $isLastChange && ($data == $value || strpos($data, $value) !== false);
                            }
                        }
                    }
                }
                return false;
            });
        } else {
            $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
                if(0 < count($resource->logs->filter(function ($log) use($log) {
                    if($onlyToDay === true && $log->date->isToday() === false) {
                        return false;
                    }
                    if($log->event == "Priority Update" && in_array($field, ["priority"])) {
                        $isLastChange = strpos($log->message, " #" . $value . " ") !== false;
                        return true;
                    }
                    if($log->event == "Status Change" && in_array($field, ["status"])) {
                        $isLastChange = strpos($log->message, " #" . $value . " ") !== false;
                        return true;
                    }
                    if($log->event == "Country Change" && in_array($field, ["country"])) {
                        $isLastChange = strpos($log->message, " #" . $value . " ") !== false;
                        return true;
                    }
                    if($log->event == "Labels Change" && in_array($field, ["labels"])) {
                        $isLastChange = strpos($log->message, " #" . $value . " ") !== false;
                        return true;
                    }
                    if($log->event == "Parameter Update" && in_array($field, ["phone", "email", "name", "lastname"])) {
                        $isLastChange = strpos($log->message, $value) !== false;
                        return true;
                    }
                    if($log->event == "Contact Type Change" && in_array($field, ["type_id"])) {
                        list($lastContect) = explode(" #", $log->message);
                        $isLastChange = strpos($lastContect, $value . " ") !== false;
                        return true;
                    }
                    if($log->event == "Labels Move" && in_array($field, ["labels"])) {
                        $findFirstEmpty = strpos($log->message, "empty");
                        $findSecountEmpty = strpos($log->message, "empty", $findFirstEmpty + 1);
                        if($findFirstEmpty !== false && $findSecountEmpty !== false) {
                            $isLastChange = false;
                            return true;
                        }
                        if($findFirstEmpty !== false && $findSecountEmpty === false) {
                            $firstHash = strpos($log->message, " #");
                            $isLastChange = $findFirstEmpty < $firstHash && strpos($log->message, " #" . $value . " ") !== false;
                            return true;
                        }
                        if($findFirstEmpty === false && $findSecountEmpty === false) {
                            $firstHash = strpos($log->message, " #");
                            $isLastChange = strpos($log->message, " #" . $value . " ", $firstHash + 1) !== false;
                            return true;
                        }
                    } else {
                        if(in_array($log->event, ["Country Unassign"]) && in_array($field, ["country"])) {
                            $isLastChange = false;
                            return true;
                        }
                        if(in_array($log->event, ["Labels Unassign"]) && in_array($field, ["labels"])) {
                            $isLastChange = false;
                            return true;
                        }
                    }
                    return false;
                }))) {
                    if(is_array($resource->toArray()[$field])) {
                        if(isset($resource->{$field}->id)) {
                            return $isLastChange && $resource->{$field}->id == $value;
                        }
                        return $isLastChange && array_search($value . "id", array_map(function ($e) {
                            return is_object($e) ? $e->id . "id" : $e["id"] . "id";
                        }, $resource->{$field}->toArray())) !== false;
                    }
                    return $isLastChange && ($resource->{$field} == $value || strpos($resource->{$field}, $value) !== false);
                }
                return false;
            });
        }
        return 0 < $this->resultData->count();
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
}

?>