<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

/**
 * Description of ConditionIfNotRule
 *
 * @author Rafał
 */
class ConditionIfNotRule implements RuleInterface
{
    /**
     * @var \mgCRM2\Models\AutomationRules 
     */
    protected $rule;
    protected $resultData;
    protected $fields = ["field", "value"];
    protected $customParams;
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function execute()
    {
        return $this;
    }
    public function validateRule()
    {
        $field = $this->rule->data->field;
        $value = $this->rule->data->value;
        if(is_numeric($field)) {
            $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
                if(0 < count($resource->fieldDatasWithAll)) {
                    $fieldIndex = array_search($field . "id", array_map(function ($e) {
                        return is_object($e) ? $e->field_id . "id" : $e["field_id"] . "id";
                    }, $resource->fieldDatasWithAll->toArray()), true);
                    if($fieldIndex !== false) {
                        $type = $resource->fieldDatasWithAll[$fieldIndex]->field_type;
                        $options = $resource->fieldDatasWithAll[$fieldIndex]->options;
                        $data = $resource->fieldDatasWithAll[$fieldIndex]->data;
                        switch ($type) {
                            case "radio":
                            case "select":
                                return !(0 < count($options) && array_search($value . "id", array_map(function ($e) {
                                    return is_object($e) ? $e->option_id . "id" : $e["option_id"] . "id";
                                }, $options->toArray())) !== false);
                                break;
                            default:
                                return !($data == $value || strpos($data, $value) !== false);
                        }
                    }
                }
                return true;
            });
        } else {
            $this->resultData = $this->resultData->filter(function ($resource) use($resource) {
                if(is_array($resource->toArray()[$field])) {
                    if(isset($resource->{$field}->id)) {
                        return $resource->{$field}->id != $value;
                    }
                    return array_search($value . "id", array_map(function ($e) {
                        return is_object($e) ? $e->id . "id" : $e["id"] . "id";
                    }, $resource->{$field}->toArray())) === false;
                }
                return $resource->{$field} != $value || strpos($resource->{$field}, $value) === false;
            });
        }
        return 0 < $this->resultData->count();
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if(!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
}

?>