<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\AutomationRules;

class SendEmailToAssignedAdminRule implements RuleInterface
{
    protected $rule;
    protected $resultData;
    protected $fields;
    protected $customParams;
    const SUBJECT_FIELD = "subject";
    const MESSAGE_FIELD = "message";
    const EMAIL_TEMPLATE_NAME = "Modulesgarden CRM - admin assigned template";
    public function setRule($data)
    {
        $this->rule = $data;
        return $this;
    }
    public function validateField()
    {
        $data = $this->rule->data;
        $template = $this->getMailTemplate();
        $isSuccess = true;
        foreach ($this->fields as $field) {
            if((!isset($data->{$field}) || $data->{$field} === NULL || $data->{$field} === "") && !$template->{$field}) {
                $isSuccess = false;
                return $isSuccess;
            }
        }
    }
    public function validateRule()
    {
        return true;
    }
    public function execute()
    {
        $template = $this->getMailTemplate();
        $subject = $this->rule->data->subject ?: $template->subject;
        $message = $this->rule->data->message ?: $template->message;
        foreach ($this->resultData as $resource) {
            global $CONFIG;
            $fromAddress = $CONFIG["Email"];
            $toAddress = $resource->admin->email;
            $variables = ["admin_id" => $resource->admin->id, "admin_firstname" => $resource->admin->firstname, "admin_lastname" => $resource->admin->lastname, "contact_id" => $resource->id, "contact_firstname" => $resource->name, "contact_lastname" => $resource->lastname];
            $additional["resource_id"] = $resource->id;
            require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
            $mailer = mgCRM_getMailerInstance();
            $mailer->sentEmailFromRawData($fromAddress, $toAddress, $subject, $message, [], $variables, $additional);
        }
        return $this;
    }
    public function setResultData($data)
    {
        $this->resultData = $data;
        return $this;
    }
    public function getResultData()
    {
        return $this->resultData;
    }
    public function setCustomParams($params)
    {
        $this->customParams = $params;
        return $this;
    }
    public function getCustomParams()
    {
        return $this->customParams;
    }
    public function getMailTemplate()
    {
        return \mgCRM2\Models\Whmcs\EmailTemplates::where("name", self::EMAIL_TEMPLATE_NAME)->first();
    }
}

?>