<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Description of CalendarSynchronization
 *
 * @author inbs
 */
class CalendarSynchronization extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    public $timestamps = true;
    protected $table = "crm_calendar_synch";
    protected $guarded = ["id"];
    protected $fillable = ["followup_id", "provider_id", "provider"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    public function followup()
    {
        return $this->belongsTo("mgCRM2\\Models\\Followup", "followup_id");
    }
    public function providerWhmcs()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Calendar", "provider_id");
    }
    public function getRemindersCountAttribute()
    {
        if(!array_key_exists("remindersCount", $this->relations)) {
            $this->load("remindersCount");
        }
        $related = $this->getRelation("remindersCount");
        return $related ? (int) $related->count : 0;
    }
    public function getId()
    {
        return isset($this->attributes["id"]) ? $this->attributes["id"] : NULL;
    }
    public function getProvider()
    {
        return isset($this->attributes["provider"]) ? $this->attributes["provider"] : NULL;
    }
    public function getProviderId()
    {
        return isset($this->attributes["provider_id"]) ? $this->attributes["provider_id"] : NULL;
    }
    public function getFollowupId()
    {
        return isset($this->attributes["followup_id"]) ? $this->attributes["followup_id"] : NULL;
    }
    public function scopeJoinfollowup($query)
    {
        return $query->with("followup");
    }
    public function scopeWhereProvider($query, $name)
    {
        return $query->where("provider", "=", $name);
    }
    public function scopeWhereFollowup($query, $id)
    {
        return $query->where("followup_id", "=", $id);
    }
    public function getFollowupIdAttribute($value)
    {
        return intval($value);
    }
    public function getProviderIdAttribute($value)
    {
        return intval($value);
    }
    public function getAdminIdAttribute($value)
    {
        return intval($value);
    }
}

?>