<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class FieldData extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_fields_data";
    protected $guarded = ["id"];
    protected $fillable = ["field_id", "field_type", "data", "resource_id"];
    /**
     * for polymorphic eloquent
     * @var type
     */
    protected $morphClass = "mgCRM2\\Models\\FieldData";
    /**
     * Determinate which column handle storing class type for various field data types
     * @var type
     */
    protected $discriminatorTypeColumn = "field_type";
    /**
     * Map, trigger what class based on type
     * @var type
     */
    protected static $fieldTypesMap;
    public function field()
    {
        return $this->belongsTo("mgCRM2\\Models\\Field", "field_id");
    }
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function options()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldDataOption", "field_data_id");
    }
    public function mapData(array $attributes)
    {
        $entityType = isset($attributes[$this->discriminatorTypeColumn]) ? strtolower($attributes[$this->discriminatorTypeColumn]) : NULL;
        if(!array_key_exists($entityType, self::$fieldTypesMap)) {
            throw new \Illuminate\Database\Eloquent\ModelNotFoundException(self::$fieldTypesMap[$entityType]);
        }
        $class = self::$fieldTypesMap[$entityType];
        return new $class();
    }
    public static function getMappedClass($entityType)
    {
        if(!array_key_exists($entityType, self::$fieldTypesMap)) {
            throw new \Illuminate\Database\Eloquent\ModelNotFoundException(self::$fieldTypesMap[$entityType]);
        }
        return self::$fieldTypesMap[$entityType];
    }
    public function newFromBuilder($attributes = [], $connection = NULL)
    {
        $m = $this->mapData((array) $attributes)->newInstance([], true);
        $m->setRawAttributes((array) $attributes, true);
        return $m;
    }
    public function newRawQuery()
    {
        $builder = new \Illuminate\Database\Eloquent\Builder($this->newBaseQueryBuilder());
        $builder->setModel($this)->with($this->with);
        return $builder;
    }
    public function newQuery($excludeDeleted = true)
    {
        $builder = $this->newRawQuery();
        if($excludeDeleted && $this->softDelete) {
            $builder->whereNull($this->getQualifiedDeletedAtColumn());
        }
        return $builder;
    }
    public function save(array $options = [])
    {
        $query = $this->newRawQuery();
        if($this->fireModelEvent("saving") === false) {
            return false;
        }
        if($this->exists) {
            $saved = $this->performUpdate($query, $options);
        } else {
            $saved = $this->performInsert($query, $options);
            $this->exists = $saved;
        }
        if($saved) {
            $this->finishSave($options);
        }
        return $saved;
    }
    public function getBaseTypes()
    {
        return array_keys(self::$fieldTypesMap);
    }
    public function toBaseObject()
    {
        $object = app()->make($this->morphClass);
        $object->setRawAttributes((array) $this->getAttributes());
        return $object;
    }
    public function scopeWithResource($query, $id)
    {
        return $query->where("resource_id", "=", $id);
    }
    public function scopeJoinField($query)
    {
        return $query->with("field");
    }
    public function scopeJoinFieldGoup($query)
    {
        return $query->with(["field" => function ($query) {
            $query->JoinGroup();
        }]);
    }
    public function scopeJoinAssignedOptions($query)
    {
        return $query->with("options");
    }
    public function scopeJoinAssignedOptionsAndOption($query)
    {
        return $query->with("options.option");
    }
    public function scopeJoinFieldValidators($query)
    {
        return $query->with(["field" => function ($query) {
            $query->joinValidators();
        }]);
    }
    public function scopeJoinFieldOptions($query)
    {
        return $query->with(["field" => function ($query) {
            $query->joinOptions();
        }]);
    }
    public function scopeJoinFillStackField($query)
    {
        return $query->with(["field" => function ($query) {
            $query->JoinGroup()->joinOptions()->joinValidators();
        }]);
    }
    public function scopeJoinFieldValidatorAndOptions($query)
    {
        return $query->with(["field" => function ($query) {
            $query->joinOptions()->joinValidators();
        }]);
    }
}

?>