<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\FieldTypes;

/**
 * this class handle 'Text' data field's
 */
class Phone extends Source\FieldTypeAbstract implements Source\FieldTypeInterface
{
    /**
     * Plain flag for multiple values that could be assigned for this field
     * @var bolean
     */
    protected $multiple = false;
    /**
     * We want to keep validators here
     * @var array
     */
    protected $possibleValidators = ["required", "min", "max", "email", "url", "ip", "regex"];
    public function validateRequired()
    {
        return !empty($this->data);
    }
    public function validateMin()
    {
        $length = intval(array_get($this->config, "min", 3));
        return $length <= strlen($this->data);
    }
    public function validateMax()
    {
        $length = intval(array_get($this->config, "max", 3));
        return $length <= strlen($this->data);
    }
    public function validateRegex()
    {
        $regex = intval(array_get($this->config, "regex", "^(\\(?\\+?[0-9]*\\.?\\)?)?[0-9_\\- \\(\\)]*\$"));
        return preg_match($regex, $this->data) == 1;
    }
    public function validateEmail()
    {
        return filter_var($this->data, FILTER_VALIDATE_EMAIL);
    }
    public function validateIp()
    {
        return filter_var($this->data, FILTER_VALIDATE_IP);
    }
    public function validateUrl()
    {
        return filter_var($this->data, FILTER_VALIDATE_URL);
    }
    public function validate($params = [])
    {
        foreach ($this->field->validators as $v) {
            if($v->type == "required" && empty($params)) {
                throw new \Exception($v->error);
            }
            if($v->type == "min") {
                if(!\mgCRM2\Models\Validators\Common::validMinCharacters($params, $v->value)) {
                    throw new \Exception($v->error);
                }
            } elseif($v->type == "max") {
                if(!\mgCRM2\Models\Validators\Common::validMaxCharacters($params, $v->value)) {
                    throw new \Exception($v->error);
                }
            } elseif($v->type == "regex") {
                if(!\mgCRM2\Models\Validators\Common::isValidByRegex($params, sprintf("/%s/", $v->value))) {
                    throw new \Exception($v->error);
                }
            } elseif($v->type == "email") {
                if(!\mgCRM2\Models\Validators\Common::isValidEmail($params)) {
                    throw new \Exception($v->error);
                }
            } elseif($v->type == "url" && !\mgCRM2\Models\Validators\Common::isValidUrl($params)) {
                throw new \Exception($v->error);
            }
        }
        return true;
    }
    public function setData($newValue)
    {
        if($this->data != $newValue) {
            $this->validate($newValue);
            $this->data = $newValue ? $newValue : "";
            $this->save();
        }
        return true;
    }
    public function setDataFromMigration(&$field, $newValue)
    {
        $this->data = $newValue;
        $this->save();
        return true;
    }
    public function getData()
    {
        return $this->data;
    }
}

?>