<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\FieldTypes;

/**
 * this class handle 'Text' data field's
 */
class Radio extends Source\FieldTypeAbstract implements Source\FieldTypeInterface
{
    /**
     * Plain flag for multiple values that could be assigned for this field
     * @var bolean
     */
    protected $multiple = true;
    /**
     * We want to keep validators here
     * @var array
     */
    protected $possibleValidators = ["required", "min", "max"];
    public function validateRequired()
    {
        return !empty($this->data);
    }
    public function validateMin()
    {
        $length = intval(array_get($this->config, "min", 3));
        return $length <= strlen($this->data);
    }
    public function validateMax()
    {
        $length = intval(array_get($this->config, "max", 3));
        return $length <= strlen($this->data);
    }
    public function validate($params = [])
    {
        foreach ($this->field->validators as $v) {
            if($v->type == "required" && empty($params)) {
                throw new \Exception("Check at least single option");
            }
        }
        return true;
    }
    public function setData($newValue)
    {
        if(is_array($newValue)) {
            $options = $newValue;
        } elseif(is_numeric($newValue)) {
            $options = [$newValue];
        } else {
            throw new \Exception("Invalid value for checkbox data type");
        }
        $this->validate($options);
        $this->save();
        $this->options()->delete();
        if(is_array($options) && !empty($options)) {
            $fieldOptions = \mgCRM2\Models\FieldOption::whereIn("id", $options)->get();
            $optionsToAssociate = [];
            foreach ($fieldOptions as $option) {
                $optionsToAssociate[] = new \mgCRM2\Models\FieldDataOption(["option_id" => $option["id"]]);
            }
        }
        if(!empty($optionsToAssociate)) {
            $this->options()->saveMany($optionsToAssociate);
        }
        return true;
    }
    public function setDataFromMigration(&$field, $newValue)
    {
        $found = false;
        foreach ($field->options as $option) {
            if(strpos($option->value, $newValue) !== false) {
                $found = $option;
            }
        }
        if($found === false) {
            $found = new \mgCRM2\Models\FieldOption(["field_id" => $field->id, "value" => $newValue]);
            $found->save();
            $field->load("options");
        }
        if($found->id) {
            $optionToAttch = new \mgCRM2\Models\FieldDataOption(["option_id" => $found->id]);
            $this->save();
            $this->options()->save($optionToAttch);
        }
        return true;
    }
    public function getData()
    {
        return $this->options()->first()->option()->first()->value;
    }
}

?>