<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models\FieldTypes\Source;

/**
 * Basic standard abstract class for each of possible field type
 * since cod has to be DRY
 */
abstract class FieldTypeAbstract extends \mgCRM2\Models\Source\AbstractModel
{
    /**
     * Disable timestamps for model
     * @var bolean
     */
    public $timestamps = false;
    /**
     * Set up table
     * @var type
     */
    protected $table = "crm_fields_data";
    /**
     * This valuea are not changable directly
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * These we can fill
     * @var type
     */
    protected $fillable = ["field_id", "resource_id", "data", "field_type"];
    /**
     * Container for Value
     * @var type
     */
    protected $value;
    /**
     * Keep field config here
     * @var type
     */
    protected $config = [];
    /**
     * Plain flag for multiple values that could be assigned for this field
     * @var bolean
     */
    protected $multiple = false;
    /**
     * We want to keep validators here
     * @var array
     */
    protected $possibleValidators = [];
    /**
     * container for invalid messages collector
     * @var array
     */
    protected $invalids = [];
    public function field()
    {
        return $this->belongsTo("mgCRM2\\Models\\Field", "field_id");
    }
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function options()
    {
        return $this->hasMany("mgCRM2\\Models\\FieldDataOption", "field_data_id");
    }
    public function setValidators(array $validators = [])
    {
        foreach ($validators as $v) {
            if(in_array($v["type"], $this->possibleValidators)) {
                $this->config[$v["type"]] = $v;
            }
        }
    }
    public function isValid()
    {
        $this->invalids = [];
        foreach ($this->config as $v) {
            $method = "validate" . ucfirst($v["type"]);
            if(method_exists($this, $method)) {
                if(!$this->{$method}) {
                    $this->invalids[] = $v["error"] ? $v["error"] : sprintf("Field is not valid by validator #%s, type: %s.", $v["id"], $v["type"]);
                }
            }
        }
        return empty($this->invalids);
    }
    public function getInvalids()
    {
        return $this->invalids;
    }
    public function setData($data);
    public function attachToResource(\mgCRM2\Models\Resource &$resource)
    {
        return $this->resource()->associate($resource);
    }
    public function getResourceIdAttribute($value)
    {
        return intval($value);
    }
    public function getFieldIdAttribute($value)
    {
        return intval($value);
    }
    public function isMultiple()
    {
        return $this->multiple;
    }
}

?>