<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class Followup extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    public $timestamps = true;
    protected $table = "crm_followups";
    protected $guarded = ["id"];
    protected $fillable = ["resource_id", "type_id", "status_id", "admin_id", "date", "description"];
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["date", "deleted_at", "updated_at", "created_at"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = true;
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function type()
    {
        return $this->belongsTo("mgCRM2\\Models\\FollowupType", "type_id");
    }
    public function status()
    {
        return $this->belongsTo("mgCRM2\\Models\\FollowupStatus", "status_id");
    }
    public function admin()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Admin", "admin_id");
    }
    public function reminders()
    {
        return $this->hasMany("mgCRM2\\Models\\Reminder", "followup_id");
    }
    public function remindersCount()
    {
        return $this->hasOne("mgCRM2\\Models\\Reminder")->selectRaw("followup_id, count(*) as count")->groupBy("followup_id");
    }
    public function getRemindersCountAttribute()
    {
        if(!array_key_exists("remindersCount", $this->relations)) {
            $this->load("remindersCount");
        }
        $related = $this->getRelation("remindersCount");
        return $related ? (int) $related->count : 0;
    }
    public function scopeJoinAdmin($query)
    {
        return $query->with("admin");
    }
    public function scopeJoinAdminRelevant($query)
    {
        return $query->with(["admin" => function ($query) {
            $query->select("id", "firstname", "lastname", "email");
        }]);
    }
    public function scopeJoinType($query)
    {
        return $query->with("type");
    }
    public function scopeJoinStatus($query)
    {
        return $query->with("status");
    }
    public function scopeJoinResource($query)
    {
        return $query->with("resource");
    }
    public function scopeJoinReminders($query)
    {
        return $query->with("reminders");
    }
    public function scopeWhereResource($query, $id)
    {
        return $query->where("crm_followups.resource_id", "=", $id);
    }
    public function scopeWhereAdmin($query, $id)
    {
        return $query->where("crm_followups.admin_id", "=", $id);
    }
    public function scopeWhereNoAdmin($query)
    {
        return $query->whereNull("crm_followups.admin_id");
    }
    public function scopeWhereCampaign($query, $campaignID)
    {
        return $query->leftJoin("crm_campaigns_resources", function ($join) use($join) {
            $join->on("crm_followups.resource_id", "=", "crm_campaigns_resources.resource_id")->on("crm_campaigns_resources.campaign_id", "=", \Illuminate\Database\Capsule\Manager::raw($campaignID));
        })->where("crm_campaigns_resources.campaign_id", "=", $campaignID);
    }
    public function scopeWhereNoCampaign($query)
    {
        return $query->leftJoin("crm_campaigns_resources", function ($join) {
            $join->on("crm_followups.resource_id", "=", "crm_campaigns_resources.resource_id");
        })->whereNull("crm_campaigns_resources.campaign_id");
    }
    public function scopeJoinLeadTypeAndName($query)
    {
        return $query->with(["resource" => function ($query) {
            $query->withTrashed()->select("crm_resources.id", \Illuminate\Database\Capsule\Manager::raw(" CONCAT( crm_resources.name, ' ', crm_resources.lastname) AS name"), "crm_resources.status_id", "crm_resources_types.color as type_color", "crm_resources_types.icon as type_icon", "crm_resources_types.name as type_name")->leftJoin("crm_resources_types", "crm_resources.type_id", "=", "crm_resources_types.id")->whereNull("crm_resources.deleted_at");
        }]);
    }
    public function scopeWithDescription($query, $str = "")
    {
        return $query->where("description", "LIKE", "%" . $str . "%");
    }
    public function getResourceIdAttribute($value)
    {
        return intval($value);
    }
    public function getTypeIdAttribute($value)
    {
        return intval($value);
    }
    public function getAdminIdAttribute($value)
    {
        return intval($value);
    }
    public function dropWithReminders()
    {
        $this->reminders()->withTrashed()->forceDelete();
        return parent::forceDelete();
    }
    public function reschedueWithReminders(array $data = [])
    {
        $newDate = \Carbon\Carbon::parse(array_get($data, "date"));
        $updateReminders = array_get($data, "updateReminders");
        if(!Validators\Common::isBolean($updateReminders)) {
            $updateReminders = false;
        }
        $reason = array_get($data, "reason");
        $timeDiff = $this->date->diffInMinutes($newDate);
        $plusToDate = $newDate->gt($this->date);
        if($updateReminders === true) {
            foreach ($this->reminders as $reminder) {
                $reminder->reschedue($plusToDate, $timeDiff);
            }
        }
        $this->date = $newDate;
        return $this->save();
    }
    public function scopeWithResourceAndStatus($query)
    {
        return $query->with(["resource" => function ($query) {
            $query->withTrashed()->with("status");
        }]);
    }
}

?>