<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Description of googleModel
 *
 * @author inbs
 */
class GoogleModel
{
    protected $id;
    protected $data = [];
    protected $authClient;
    protected $calendar_id;
    /**
     * @var Google_Service_Calendar
     */
    protected $service;
    public function __construct(array $data = [])
    {
        if(isset($data)) {
            $this->id = $data["id"];
        }
        $this->data = $data;
        if(!isset($this->data) && !isset($this->id)) {
            throw new \Exception("Empty Data And Id");
        }
        $settings = new \mgCRM2\Repositories\Settings();
        $app = \mgCRM2\Integration\Slim\SlimApp::getInstance();
        $auth = new \mgCRM2\Helpers\AuthGoogle($settings->getGlobal(), $app);
        $this->authClient = $auth->getClient(true);
        $this->service = new \Google_Service_Calendar($this->authClient);
        $this->calendar_id = $settings->getGlobal()["selected_calendar"];
    }
    protected function formatDate($dateString, $isEnd = false)
    {
        $objDateTime = new \DateTime($dateString);
        if($isEnd) {
            $objDateTime->add(new \DateInterval("PT1H"));
        }
        return $objDateTime->format(\DateTime::ATOM);
    }
    public function getCalendarList()
    {
        if($this->authClient->getAccessToken()) {
            $calendars = [];
            $calendarClient = new \Google_Service_Calendar($this->authClient);
            $calendarList = $calendarClient->calendarList->listCalendarList()->getItems();
            foreach ($calendarList as $calendar) {
                $id = $calendar["id"];
                $name = $calendar["summary"];
                $calendars[$id] = $name;
            }
            return $calendars;
        }
    }
    public function insert()
    {
        $url = array_get($this->data, "url_followup", "");
        $event = new \Google_Service_Calendar_Event(["summary" => array_get($this->data, "type_name", "") . " - " . array_get($this->data, "titleName", "") . ", created by " . array_get($this->data, "admin", ""), "description" => array_get($this->data, "description", NULL) . " \n\r---\n" . $url, "start" => ["dateTime" => $this->formatDate(array_get($this->data, "date", "0000-00-00 00:00:00"))], "end" => ["dateTime" => $this->formatDate(array_get($this->data, "date", "0000-00-00 00:00:00"), true)], "reminders" => ["useDefault" => true]]);
        $result = $this->service->events->insert($this->calendar_id, $event);
        if(!$result) {
            throw new \Exception("Don't create event!");
        }
        return $result;
    }
    public function update(array $newData = [])
    {
        $event = $this->service->events->get($this->calendar_id, $this->id);
        $url = array_get($newData, "url_followup", "");
        $event->setDescription(array_get($newData, "description", NULL) . " \n\r---\n" . $url);
        $startDate = new \Google_Service_Calendar_EventDateTime();
        $endDate = new \Google_Service_Calendar_EventDateTime();
        $startDate->setDateTime($this->formatDate(array_get($newData, "date", "0000-00-00 00:00:00")));
        $endDate->setDateTime($this->formatDate(array_get($newData, "date", "0000-00-00 00:00:00"), true));
        $event->setStart($startDate);
        $event->setEnd($endDate);
        $updatedEvent = $this->service->events->update($this->calendar_id, $event->getId(), $event);
        return $updatedEvent->getUpdated();
    }
    public function delete()
    {
        $event = $this->service->events->delete($this->calendar_id, $this->id);
    }
}

?>