<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class For Mass Mail Config records
 */
class MassMessagePending extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_mass_message_pendings";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["mass_message_config_id", "client_id", "resource_id", "message_content", "message_title", "message_type"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    /**
     * Basically possible messages types for validation
     * as protection layer
     *
     * @var type
     */
    protected static $allowedMessageTypes;
    public function setMessageTypeAttribute($value)
    {
        if(!in_array($value, self::$allowedMessageTypes)) {
            throw new \Exception("Invalid Message Type");
        }
        $this->attributes["message_type"] = $value;
    }
    public function client()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Client", "client_id");
    }
    public function scopeFix($query)
    {
        return $query;
    }
    public function toArray()
    {
        if($this->client) {
            $this->client->markAllColumnsVisible();
        }
        $array = parent::toArray();
        return $array;
    }
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function messageConfig()
    {
        return $this->belongsTo("mgCRM2\\Models\\MassMessageConfig", "mass_message_config_id");
    }
    public function sent()
    {
        if($this->message_type == "sms") {
            return $this->sentAsSms();
        }
        if($this->message_type == "email") {
            return $this->sentAsEmail();
        }
        return false;
    }
    protected function sentAsEmail()
    {
        $clientEmail = $this->client->email;
        $resourceEmail = $this->resource->email;
        $resourceClientEmail = $this->resource->client->email;
        $mailBoxId = false;
        $client_id = NULL;
        $fromEmail = NULL;
        if(!empty($this->client->email)) {
            $targetEmail = $this->client->email;
            $client_id = $this->client->id;
        } elseif(!empty($this->resource->client->email)) {
            $targetEmail = $this->resource->client->email;
            $client_id = $this->resource->client->id;
        } elseif(!empty($this->resource->email)) {
            $targetEmail = $this->resource->email;
        }
        if(!Validators\Common::isValidEmail($targetEmail)) {
            throw new \Exception(sprintf("Email (%s) is not valid", $targetEmail));
        }
        $smartyVariables = [];
        if($this->messageConfig) {
            array_set($smartyVariables, "config", $this->messageConfig->toArray());
            if($this->messageConfig->mailbox_id != NULL && $this->messageConfig->mailbox_id != 0) {
                $mailBoxId = (int) $this->messageConfig->mailbox_id;
            }
        }
        if($this->client->id) {
            array_set($smartyVariables, "client", $this->client->markAllColumnsVisible()->toArray());
        }
        if($this->resource->id) {
            $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
            $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($this->resource->id);
            array_set($smartyVariables, "contact", $this->resource->toArray());
            $smartyVariables["contact"]["fields"] = $fieldsData;
            if($this->resource->client->id) {
                array_set($smartyVariables, "contact.client", $this->resource->client->markAllColumnsVisible()->toArray());
            }
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $mailer = mgCRM_getMailerInstance();
        $result = $mailer->sentRawEmail([$targetEmail], [], [], NULL, $this->message_title, $this->message_content, [], $smartyVariables, ["resource_id" => $this->resource_id, "client_id" => $client_id, "mailbox_id" => $mailBoxId]);
        $logArray = ["id" => $this->id, "cid" => $this->mass_message_config_id, "email" => $targetEmail];
        if($result) {
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Mass Message (id:{id} from config #{cid}) has been send to {email}", $logArray);
            $this->forceDelete();
            return true;
        }
        \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: Mass Message (id:{id} from config #{cid}) Unable to sent to {email}", $logArray);
        return false;
    }
    protected function sentAsSms()
    {
        $clientId = $this->client->id;
        $resourceClientId = $this->resource->client->id;
        $resourcePhone = $this->resource->phone;
        $targetClientID = $targetPhone = NULL;
        if($clientId) {
            $targetClientID = $clientId;
        } elseif($resourceClientId) {
            $targetClientID = $resourceClientId;
        } elseif(!empty($resourcePhone)) {
            $targetPhone = $resourcePhone;
        }
        if(!($targetClientID || $targetPhone)) {
            throw new \Exception(sprintf("No Target phone provided to sent sms"));
        }
        $smartyVariables = [];
        if($this->message_config) {
            array_set($smartyVariables, "config", $this->message_config->toArray());
        }
        if($this->client->id) {
            array_set($smartyVariables, "client", $this->client->markAllColumnsVisible()->toArray());
        }
        if($this->resource->id) {
            $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
            $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($this->resource->id);
            array_set($smartyVariables, "contact", $this->resource->toArray());
            array_add($smartyVariables["contact"], "fields", $fieldsData);
            if($this->resource->client->id) {
                array_set($smartyVariables, "contact.client", $this->resource->client->markAllColumnsVisible()->toArray());
            }
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $sender = mgCRM_getSenderSmsInstance();
        $result = $sender->sentRawSMSForClient($targetClientID, $targetPhone, $this->message_content, $smartyVariables, ["resource_id" => $this->resource_id, "client_id" => $this->client_id]);
        $logArray = ["id" => $this->id, "cid" => $this->mass_message_config_id, "msg" => $result["message"]];
        if($result["result"] == "success") {
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("CRON: SMS Mass Message (id:{id} from config #{cid}) has been added to SMS Center. Message: {msg}", $logArray);
            $this->forceDelete();
            return true;
        }
        \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->error("CRON: SMS Mass Message (id:{id} from config #{cid}) Unable to sent: {msg}", $logArray);
        return false;
    }
}

?>