<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class Reminder extends Source\AbstractModel
{
    use Illuminate\Database\Eloquent\SoftDeletes;
    public $timestamps = true;
    protected $table = "crm_followup_reminders";
    protected $guarded = ["id"];
    protected $fillable = ["followup_id", "template_id", "type", "status", "target", "target_id", "date", "cc", "bcc", "reply"];
    protected $softDelete = true;
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ["date", "deleted_at", "updated_at", "created_at"];
    public function followup()
    {
        return $this->belongsTo("mgCRM2\\Models\\Followup", "followup_id");
    }
    public function template()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\EmailTemplates", "template_id");
    }
    public function getFollowupIdAttribute($value)
    {
        return intval($value);
    }
    public function getTargetIdAttribute($value)
    {
        return intval($value);
    }
    public function getTemplateIdAttribute($value)
    {
        return intval($value);
    }
    public function getReplyAttribute($value)
    {
        if(is_null($value)) {
            return $value;
        }
        return intval($value);
    }
    public function scopeSearchOld($query)
    {
    }
    public function scopeSearchByTwoDates($query)
    {
    }
    public function scopeSearchToSend($query)
    {
    }
    public function getCcAttribute($value)
    {
        return json_decode($value, true);
    }
    public function setCcAttribute($value)
    {
        $this->attributes["cc"] = json_encode($value);
    }
    public function getBccAttribute($value)
    {
        return json_decode($value, true);
    }
    public function setBccAttribute($value)
    {
        $this->attributes["bcc"] = json_encode($value);
    }
    public function scopeForFollowupResource($query, $resourceID, $followupID)
    {
        return $query->forFollowup($followupID)->with(["followup" => function ($query) use($query) {
            $query->where("resource_id", "=", $resourceID);
        }]);
    }
    public function scopeForFollowup($query, $followupID)
    {
        return $query->where("followup_id", "=", $followupID);
    }
    public function scopeWhereId($query, $id)
    {
        return $query->where("id", "=", $id);
    }
    public function reschedue($plusToDate, $timeDiff)
    {
        $newDate = $this->date->copy();
        if($plusToDate === true) {
            $this->date = $this->date->addMinutes($timeDiff);
        } else {
            $this->date = $this->date->subMinutes($timeDiff);
        }
        return $this->save();
    }
    public function scopePendingOrError($query)
    {
        return $query->whereIn("status", ["pending", "error"]);
    }
    public function scopeBeforeNow($query)
    {
        return $query->where("date", "<=", \Carbon\Carbon::now());
    }
    public function sent()
    {
        if($this->type == "sms") {
            return $this->sentSmsReminder();
        }
        return $this->sentEmailReminder();
    }
    protected function sentEmailReminder()
    {
        $recipients = [];
        $cc = [];
        $bcc = [];
        $replyTo = [];
        $smartyVariables = [];
        $emailTemplate = $this->template_id;
        if($this->target == "resource") {
            $targetEmail = $this->followup->resource->getEmailForReminder();
            if(!Validators\Common::isValidEmail($targetEmail)) {
                throw new \Exception(sprintf("Email (%s) is not valid", $targetEmail));
            }
            $recipients[] = $targetEmail;
        } elseif($this->target == "admin") {
            $target = Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->findOrFail($this->target_id);
            $smartyVariables["admin"] = $target->toArray();
            if(!Validators\Common::isValidEmail($target->email)) {
                throw new \Exception(sprintf("Email (%s) is not valid", $target->email));
            }
            $recipients[] = $target->email;
        } else {
            return $this->sentClientSmsReminder();
        }
        if(Validators\Common::isPositiveNumber($this->reply) && !is_null($this->reply)) {
            $adminObj = Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->findOrFail($this->reply);
            $replyTo = ["email" => $adminObj->email, "name" => $adminObj->full];
        }
        if(is_array($this->cc) && !empty($this->cc)) {
            $admins = Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->whereIn("id", $this->cc)->get();
            foreach ($admins as $a) {
                if(Validators\Common::isValidEmail($a->email)) {
                    $cc[] = ["email" => $a->email, "name" => $a->full];
                }
            }
        }
        if(is_array($this->bcc) && !empty($this->bcc)) {
            $admins = Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->whereIn("id", $this->bcc)->get();
            foreach ($admins as $a) {
                if(Validators\Common::isValidEmail($a->email)) {
                    $bcc[] = ["email" => $a->email, "name" => $a->full];
                }
            }
        }
        $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
        $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($this->followup->resource_id);
        $this->followup->resource->load("status", "client", "ticket");
        array_set($smartyVariables, "contact", $this->followup->resource->toArray());
        array_set($smartyVariables, "followup", $this->followup->toArray());
        $smartyVariables["contact"]["fields"] = $fieldsData;
        $typeId = $smartyVariables["followup"]["type_id"];
        $followupTypeRepo = new \mgCRM2\Repositories\FollowupTypes();
        $followupType = $followupTypeRepo->find($typeId);
        array_set($smartyVariables, "followup.type", $followupType->toArray());
        if($this->followup->resource->client->id) {
            array_set($smartyVariables, "contact.client", $this->followup->resource->client->markAllColumnsVisible()->toArray());
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $mailer = mgCRM_getMailerInstance();
        $result = $mailer->sentReminderEmailFromTemplate($emailTemplate, $recipients, $replyTo, $cc, $smartyVariables, ["resource_id" => $this->followup->resource->id, "followup_id" => $this->followup->id, "reminder_id" => $this->id, "bcc" => $bcc]);
        if($result) {
            $this->status = "sent";
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("Reminder #{id} has been sent", ["id", $this->id]);
        } else {
            $this->status = "error";
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->error("Unable to send Reminder #{id}", ["id", $this->id]);
        }
        $this->save();
        return $result;
    }
    protected function sentClientSmsReminder()
    {
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
        $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($this->followup->resource_id);
        $this->followup->resource->load("status", "client", "ticket");
        array_set($smartyVariables, "contact", $this->followup->resource->toArray());
        array_set($smartyVariables, "followup", $this->followup->toArray());
        array_add($smartyVariables["contact"], "fields", $fieldsData);
        $getMergeFields = $smartyVariables["contact"];
        foreach ($getMergeFields as $key => $value) {
            if(!strpos($key, "_")) {
                $getMergeFields["client_" . $key] = $value;
                unset($getMergeFields[$key]);
            }
            if(isset($getMergeFields["client_phone"])) {
                $getMergeFields["client_phonenumber"] = $value;
                unset($getMergeFields["client_phone"]);
            }
        }
        if($this->followup->resource->client->id) {
            array_set($smartyVariables, "contact.client", $this->followup->resource->client->markAllColumnsVisible()->toArray());
            $bootstrapSmsCenter = ROOTDIR . DIRECTORY_SEPARATOR . "modules" . DIRECTORY_SEPARATOR . "addons" . DIRECTORY_SEPARATOR . "sms_center" . DIRECTORY_SEPARATOR . "Bootstrap.php";
            if(class_exists("\\ModulesGarden\\SmsCenter\\App\\Helper\\SmartyHelper\\Client") === false && file_exists($bootstrapSmsCenter)) {
                require_once $bootstrapSmsCenter;
            }
            $getMergeFields = (new \ModulesGarden\SmsCenter\App\Helper\SmartyHelper\Client($this->followup->resource->client->id))->getMergeFields();
        }
        $sender = mgCRM_getSenderSmsInstance();
        $smartyVariables = array_merge($smartyVariables, $getMergeFields);
        if(!$smartyVariables["contact"]["phone"] && $smartyVariables["contact"]["client"]) {
            $sms_number = str_replace(" ", "", \Illuminate\Database\Capsule\Manager::select("SELECT tblcustomfieldsvalues.value FROM `tblcustomfieldsvalues`\n                                     join crm_resources\n                                     on tblcustomfieldsvalues.relid = crm_resources.client_id\n                                     join tblcustomfields\n                                     on tblcustomfields.id = tblcustomfieldsvalues.fieldid\n                                     where tblcustomfields.fieldname LIKE \"%sms_number%\"\n                                     AND  crm_resources.id = " . $this->target_id)[0]["value"]);
        }
        list($template) = \Illuminate\Database\Capsule\Manager::select("SELECT template.message\n                             FROM `SmsCenter_Templates` template\n                             join SmsCenter_MessageGroups `group`\n                             on template.group_id=group.id\n                             join tblemailtemplates emailtemplate\n                             on group.msg_name=emailtemplate.name\n                             where emailtemplate.id = " . $this->template_id . " ORDER BY `emailtemplate`.`id` ASC");
        $smarty = $sender::makeSmartyObject();
        $smarty->assign($smartyVariables);
        $message = trim($sender::smartyStringFetch($smarty, $template->message));
        $phonenumber = !empty($smartyVariables["contact"]["phone"]) ? $smartyVariables["contact"]["phone"] : $sms_number;
        $params = ["phonenumber" => $phonenumber, "message" => $message];
        $adminName = \mgCRM2\Integration\Slim\SlimApp::getInstance()->whmcs->getAdminNameForAPIcall();
        $result = localAPI("sendsms", $params, $adminName);
        if($result["result"] != "error") {
            $this->status = "sent";
            $return = true;
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("SMS Reminder #{id} has been sent. {msg}", ["id", $this->id, "msg" => $result["message"]]);
        } else {
            $this->status = "error";
            $return = false;
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->error("Unable to send SMS Reminder #{id} Unable to sent: {msg}", ["id", $this->id, "msg" => $result["message"]]);
        }
        $this->save();
        return $return;
    }
    protected function sentSmsReminder()
    {
        if($this->target != "admin") {
            return $this->sentClientSmsReminder();
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $customFieldRepo = new \mgCRM2\Repositories\FieldDatas();
        $fieldsData = $customFieldRepo->getOnlyFieldsForResourceSummary($this->followup->resource_id);
        $this->followup->resource->load("status", "client", "ticket");
        array_set($smartyVariables, "contact", $this->followup->resource->toArray());
        array_set($smartyVariables, "followup", $this->followup->toArray());
        array_add($smartyVariables["contact"], "fields", $fieldsData);
        if($this->followup->resource->client->id) {
            array_set($smartyVariables, "contact.client", $this->followup->resource->client->markAllColumnsVisible()->toArray());
        }
        $sender = mgCRM_getSenderSmsInstance();
        $result = $sender->sentReminderSMSFromTemplate($this->target_id, $this->template_id, $smartyVariables);
        if($result) {
            $this->status = "sent";
            $return = true;
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->notice("SMS Reminder #{id} has been sent. {msg}", ["id", $this->id, "msg" => $result["message"]]);
        } else {
            $this->status = "error";
            $return = false;
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->error("Unable to send SMS Reminder #{id} Unable to sent: {msg}", ["id", $this->id, "msg" => $result["message"]]);
        }
        $this->save();
        return $return;
    }
}

?>