<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

/**
 * Class Model for lead/potential
 */
class ResourceQuote extends Source\AbstractModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = "crm_resources_quotes";
    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ["id"];
    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ["resource_id", "quote_id"];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public function resource()
    {
        return $this->belongsTo("mgCRM2\\Models\\Resource", "resource_id")->withTrashed();
    }
    public function quote()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Quote", "quote_id");
    }
    public function getResourceIdAttribute($value)
    {
        return intval($value);
    }
    public function getQuoteIdAttribute($value)
    {
        return intval($value);
    }
    public function scopeForResource($query, $id)
    {
        return $query->where("resource_id", "=", $id);
    }
    public function scopeForQuote($query, $quoteID)
    {
        return $query->where("quote_id", "=", $quoteID);
    }
    public function scopeWithQuote($query)
    {
        return $query->with("quote");
    }
    public function scopeWithQuoteOrder($query, $orderBy = "datecreated", $orderDesc = "desc")
    {
        return $query->with(["quote" => function ($query) use($query) {
            $query->orderBy($orderBy, $orderDesc);
        }]);
    }
}

?>