<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class Setting extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_settings";
    protected $fillable = ["name", "admin_id", "value"];
    /**
     * primaryKey
     *
     * @var integer
     * @access protected
     */
    protected $primaryKey = ["name", "admin_id"];
    /**
     * Indicates if the IDs are auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = false;
    protected $parsedValue;
    public function getValueAttribute($value)
    {
        if(isset($this->parsedValue)) {
            return $this->parsedValue;
        }
        $decoded = json_decode($value, true);
        if(!is_null($decoded)) {
            $this->parsedValue = $decoded;
        } else {
            $this->parsedValue = $value;
        }
        return $this->parsedValue;
    }
    public function setValueAttribute($value)
    {
        $encode = true;
        if(is_array($value)) {
            $this->attributes["value"] = json_encode($value, true);
        } else {
            $this->attributes["value"] = $value;
        }
    }
    protected function setKeysForSaveQuery(\Illuminate\Database\Eloquent\Builder $query)
    {
        if(is_array($this->primaryKey)) {
            foreach ($this->primaryKey as $pk) {
                $query->where($pk, "=", $this->original[$pk]);
            }
            return $query;
        } else {
            return parent::setKeysForSaveQuery($query);
        }
    }
    public function scopeForAdmin($query, $id)
    {
        return $query->where("admin_id", "=", $id);
    }
    public function scopeForGlobal($query)
    {
        return $query->where("admin_id", "=", 0);
    }
    public function scopeWhereSetting($query, $setting)
    {
        return $query->where("name", "=", $setting);
    }
}

?>