<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class WebForm extends Source\AbstractModel
{
    public $timestamps = true;
    protected $table = "crm_webforms";
    protected $guarded = ["id"];
    protected $fillable = ["name", "url", "type_id", "contact_quantity", "status_id", "admin_id", "admins", "labels", "timeout", "created_at", "updated_at", "duplicate_email", "create_followup", "followup_label", "followup_status"];
    protected $dates = ["created_at", "updated_at"];
    protected $primaryKey = "id";
    protected static $fieldsRelation = ["name", "url", "timeout", "labels", "duplicate_email", "create_followup", "followup_label", "followup_status"];
    public function getAdminsAttribute($value)
    {
        return json_decode($value, true);
    }
    public function setAdminsAttribute($value)
    {
        if(empty($value) || !is_array($value) || is_null($value)) {
            $toSave = [];
        } else {
            $toSave = array_filter($value);
        }
        $this->attributes["admins"] = json_encode($toSave, true);
    }
    public function scopeWhereSearch($query, $str)
    {
        return $query->where("name", "like", "%" . $str . "%")->orWhere("id", "like", "%" . $str . "%");
    }
    public function fillDetails(array $data = [])
    {
        $parsed = [];
        foreach (self::$fieldsRelation as $staticName) {
            $value = array_get($data, $staticName, NULL);
            if($staticName == "name" && !$this->isValidateName($value)) {
                throw new \Exception(\mgCRM2\Services\Language::translate("nameCannotBeEmpty.webform.message"));
            }
            if($staticName == "url") {
                $urls = \mgCRM2\Helpers\WebForms::parseUrlStringToArray($value);
                foreach ($urls as $url) {
                    if(!Validators\Common::isValidUrl($url)) {
                        throw new \Exception("Invalid URL provided");
                    }
                }
            }
            if($staticName == "timeout" && !$this->isValidateTimeout($value)) {
                throw new \Exception("Invalid TimeOut provided");
            }
            $parsed[$staticName] = $value;
        }
        $this->fill($parsed);
    }
    public function isValidateName($val)
    {
        return Validators\Common::isEmpty($val);
    }
    public function isValidateTimeout($val)
    {
        return Validators\Common::isNumber($val);
    }
    public function isValidateUrl($val)
    {
        return Validators\Common::isValidUrl($val);
    }
    public function assignType(ResourceType $Model)
    {
        $this->type()->associate($Model);
    }
    public function assignStatus(FieldStatus $Model)
    {
        $this->status()->associate($Model);
    }
    public function assignAdmin($Model)
    {
        $this->admin()->associate($Model);
    }
    public function assignAdmins($Model)
    {
        $this->admins()->associate($Model);
    }
    public function type()
    {
        return $this->belongsTo("mgCRM2\\Models\\ResourceType", "type_id");
    }
    public function status()
    {
        return $this->belongsTo("mgCRM2\\Models\\FieldStatus", "status_id");
    }
    public function admin()
    {
        return $this->belongsTo("mgCRM2\\Models\\Whmcs\\Admin", "admin_id");
    }
    public function admins()
    {
        return $this->hasMany("mgCRM2\\Models\\Whmcs\\Admin", "admins");
    }
}

?>