<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Models;

class WebFormContent extends Source\AbstractModel
{
    public $timestamps = false;
    protected $table = "crm_webforms_contents";
    protected $guarded = ["id"];
    protected $fillable = ["webform_id", "field_id", "custom_name", "order"];
    protected $primaryKey = "id";
    protected static $fieldsRelation = ["field_id", "custom_name", "order"];
    public function fillDetails(array $data = [])
    {
        $parsed = [];
        foreach (self::$fieldsRelation as $staticName) {
            $value = array_get($data, $staticName, NULL);
            if($staticName == "field_id" && !$this->isValidateName($value)) {
                throw new \Exception("Invalid field ID");
            }
            if($staticName == "custom_name" && !$this->isValidateName($value)) {
                throw new \Exception("Invalid field name provided");
            }
            if($staticName == "order" && !$this->isValidateNumber($value)) {
                throw new \Exception("Invalid order");
            }
            $parsed[$staticName] = $value;
        }
        $this->fill($parsed);
    }
    public function fillWebFormId($id)
    {
        if(!$this->isValidateNumber($id)) {
            throw new \Exception("Invalid field ID");
        }
        $this->fill(["webform_id" => $id]);
    }
    public function isValidateName($val)
    {
        return Validators\Common::isEmpty($val);
    }
    public function isValidateNumber($val)
    {
        return Validators\Common::isPositiveNumber($val);
    }
    public function assignType(Field $Model)
    {
        $this->type()->associate($Model);
    }
    public function type()
    {
        return $this->belongsTo("mgCRM2\\Models\\Field", "field_id");
    }
}

?>