<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

class Automations extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Automations";
    }
    public function getDetails($id)
    {
        $automation = $this->getModel()->with("rules")->find($id);
        if($automation->id == $id) {
            return $automation->toArray();
        }
        throw new \Exception("Something went wrong.");
    }
    public function createAutomation(array $data = [])
    {
        $maxOrder = $lastOrder = $this->model->orderBy("order", "desc")->first()->order;
        if($maxOrder && $maxOrder && $maxOrder === 0) {
            $maxOrder = $maxOrder + 1;
        } else {
            $maxOrder = 0;
        }
        $model = new \mgCRM2\Models\Automations(["name" => array_get($data, "name", ""), "status" => array_get($data, "status", false), "order" => $maxOrder]);
        $model->save();
        if($model->id) {
            return $model->id;
        }
        throw new \Exception("Something went wrong.");
    }
    public function updateParam($id, array $data = [])
    {
        $model = $this->getModel()->find($id);
        if($model) {
            unset($data["created_at"]);
            unset($data["deleted_at"]);
            unset($data["updated_at"]);
            $model->fill($data)->save();
            return true;
        }
        throw new \Exception("Something went wrong.");
    }
    public function updateFrom($data)
    {
        $static = array_get($data, "static", []);
        $fields = array_get($data, "fields", []);
        $admins = [];
        foreach (array_get($data, "admins", []) as $ad) {
            $admins[] = $ad["id"];
        }
        $this->checkRequired($static, $fields);
        $webform = $this->getModel()->find($static["id"]);
        $webform->fillDetails($static);
        $webform->setAdminsAttribute($admins);
        if(array_get($data, "contact_type.id", NULL) != NULL) {
            $webform->assignType(\mgCRM2\Models\ResourceType::find(array_get($data, "contact_type.id")));
            if(array_get($data, "status.id", NULL) != NULL) {
                $webform->assignStatus(FieldStatus::find(array_get($data, "status.id")));
                if(array_get($data, "assignedAdmin.id", NULL) != NULL) {
                    $webform->assignAdmin(\mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(array_get($data, "assignedAdmin.id")));
                    if(empty($fields)) {
                        throw new \Exception("Empty Fields list");
                    }
                    $wc = new WebFormsContents();
                    $wc->deleteWebformFields($static["id"]);
                    foreach ($fields as $key => $field) {
                        $content = new WebFormsContents();
                        $content->createAndAssigneToWebForm($static["id"], $field, $key);
                    }
                    $webform->setUpdatedAt($webform->freshTimestamp());
                    $webform->save();
                } else {
                    throw new \Exception("Invalid Contact Admin");
                }
            } else {
                throw new \Exception("Invalid Contact Status");
            }
        } else {
            throw new \Exception("Invalid Contact Type");
        }
    }
    public function getListTableQuery($data)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $offset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "order");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $query = $this->getModel();
        if(!empty($searchGlobal)) {
            $query = $query->whereSearch($searchGlobal);
        }
        $total = $query->count();
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($offset)->get()->toArray();
        $return = ["data" => $results, "total" => $total];
        return $return;
    }
    public function getURLsFromWebForms()
    {
        $query = $this->getModel();
        $result = $query->get(["url"])->toArray();
        return $result;
    }
    private function checkRequired($static, $fields)
    {
        if(empty($fields)) {
            throw new \Exception("Empty Fields list");
        }
        $hasRequired = false;
        foreach ($fields as $field) {
            if($field["id"] == "R1" || $field["id"] == "R2") {
                $hasRequired = true;
            }
        }
        if(!$hasRequired) {
            throw new \Exception("Name field is required");
        }
    }
}

?>