<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Description of CalendarSynchronization
 *
 * @author inbs
 */
class CalendarSynchronization extends Source\AbstractRepository implements Source\RepositoryInterface
{
    protected $providers = [];
    public function determinateModel()
    {
        return "mgCRM2\\Models\\CalendarSynchronization";
    }
    private function generateUrl($resourceId, $followupId)
    {
        $lastWorld = $_SERVER["SCRIPT_NAME"];
        if(substr($lastWorld, 0, 1) == "/") {
            $url = $_SERVER["HTTP_HOST"] . $lastWorld;
        } else {
            $url = $_SERVER["HTTP_HOST"] . "/" . $lastWorld;
        }
        if(strpos($url, "http://") === false && strpos($url, "https://") === false) {
            $url = (isset($_SERVER["HTTPS"]) && strtoupper($_SERVER["HTTPS"]) == "ON" ? "https://" : "http://") . $url;
        }
        $url .= "#!/contacts/" . $resourceId . "/followup/" . $followupId;
        return $url;
    }
    public function createSynchronization(array $data = [])
    {
        $resutl = [];
        $resourceId = array_get($data, "resource_id", 0);
        $followupId = array_get($data, "id", 0);
        $resourceNames = \Illuminate\Database\Capsule\Manager::table("crm_resources")->select([\Illuminate\Database\Capsule\Manager::raw("`crm_resources`.`name` AS `resources`"), \Illuminate\Database\Capsule\Manager::raw("`crm_resources_types`.`name` AS `typeName`"), \Illuminate\Database\Capsule\Manager::raw("CONCAT_WS(' ', `tblclients`.`firstname`,`tblclients`.`lastname`) AS `client`"), \Illuminate\Database\Capsule\Manager::raw("CONCAT_WS(' ', tbladmins.firstname, tbladmins.lastname) as `admin`")])->leftJoin("tblclients", "tblclients.id", "LIKE", "crm_resources.client_id")->leftJoin("crm_resources_types", "crm_resources_types.id", "LIKE", "crm_resources.type_id")->leftJoin("tbladmins", "tbladmins.id", "LIKE", "crm_resources.admin_id")->where("crm_resources.id", "LIKE", $resourceId)->get();
        $followup = \Illuminate\Database\Capsule\Manager::table("crm_followups")->select([\Illuminate\Database\Capsule\Manager::raw("`crm_followup_types`.`name` AS `name`")])->leftJoin("crm_followup_types", "crm_followup_types.id", "LIKE", "crm_followups.type_id")->where("crm_followups.id", "LIKE", $followupId)->get();
        $resourceNames = (array) $resourceNames[0];
        $followup = (array) $followup[0];
        if(isset($resourceNames["client"]) && $resourceNames["client"] != NULL) {
            array_set($data, "titleName", $resourceNames["client"]);
        } else {
            array_set($data, "titleName", $resourceNames["resources"]);
        }
        if(isset($followup["name"]) && $followup["name"] != NULL) {
            array_set($data, "type_name", $followup["name"]);
        }
        if(isset($resourceNames["admin"]) && $resourceNames["admin"] != NULL) {
            array_set($data, "admin", $resourceNames["admin"]);
        }
        array_set($data, "url_followup", $this->generateUrl($resourceId, $followupId));
        if(isset($this->providers[0])) {
            array_add($resutl, 0, $this->_createSynchForWhmcs($data));
        }
        if(isset($this->providers[1])) {
            array_add($resutl, 1, $this->_createSynchForGoogle($data));
        }
        return $resutl;
    }
    protected function _createSynchForWhmcs(array $data = [])
    {
        $newCalendar = new WhmcsCalendar();
        $newCalendar = $newCalendar->create($data);
        if($newCalendar) {
            $parsed = ["followup_id" => array_get($data, "id", NULL), "provider_id" => $newCalendar->getId(), "provider" => "WHMCS Calendar"];
            $new = new \mgCRM2\Models\CalendarSynchronization($parsed);
            $new->save();
        }
        return $new;
    }
    protected function _createSynchForGoogle(array $data = [])
    {
        try {
            $model = new \mgCRM2\Models\GoogleModel($data);
            $newCalendar = $model->insert();
            if(isset($newCalendar->id)) {
                $parsed = ["followup_id" => array_get($data, "id", NULL), "provider_id" => $newCalendar->id, "provider" => "Google Calendar"];
                $new = new \mgCRM2\Models\CalendarSynchronization($parsed);
                $new->save();
            }
            return $new;
        } catch (\Exception $ex) {
            return ["error" => $exc->getMessage()];
        }
    }
    public function deleteSynchronization($id)
    {
        $found = $this->getModel()->whereFollowup($id)->get();
        $count = $found->count();
        if($count == 0) {
            return false;
        }
        $result = [];
        foreach ($found->all() as $item) {
            if(isset($this->providers[0]) && $this->providers[0]->name == $item->getProvider()) {
                $this->_deletedSynchForWhmcs($item->getProviderId());
            }
            if(isset($this->providers[1]) && $this->providers[1]->name == $item->getProvider()) {
                $this->_deletedSynchForGoogle($item->getProviderId());
            }
            $item->delete();
        }
        return $result;
    }
    protected function _deletedSynchForWhmcs($id)
    {
        $whmcsCalendarr = new WhmcsCalendar();
        $whmcsCalendarr->delete($id);
    }
    protected function _deletedSynchForGoogle($id)
    {
        try {
            $calendar = new \mgCRM2\Models\GoogleModel(["id" => $id]);
            $calendar->delete();
        } catch (\Exception $ex) {
        }
    }
    public function updateSynchronization(array $data = [])
    {
        $id = array_get($data, "id", NULL);
        $return = [];
        if($id) {
            $found = $this->getModel()->whereFollowup($id)->get();
            $count = $found->count();
            if($count == 0) {
                $this->createSynchronization($data);
                $found = $this->getModel()->whereFollowup($id)->get();
                $count = $found->count();
            }
            if($count == 0) {
                return false;
            }
            $resourceId = array_get($data, "resource_id", 0);
            $followupId = array_get($data, "id", 0);
            array_set($data, "url_followup", $this->generateUrl($resourceId, $followupId));
            foreach ($found->all() as $item) {
                if(isset($this->providers[0]) && $this->providers[0]->name == $item->getProvider()) {
                    $return[] = $this->_updatedSynchForWhmcs($item->getProviderId(), $data);
                }
                if(isset($this->providers[1]) && $this->providers[1]->name == $item->getProvider()) {
                    $return[] = $this->_updatedSynchForGoogle($item->getProviderId(), $data);
                }
            }
        }
        return $return;
    }
    protected function _updatedSynchForWhmcs($id, array $data = [])
    {
        $whmcsCalendarr = new WhmcsCalendar();
        return $whmcsCalendarr->update($id, ["admin_id" => array_get($data, "admin_id", NULL), "description" => array_get($data, "description", NULL), "date" => array_get($data, "date", NULL)]);
    }
    protected function _updatedSynchForGoogle($id, array $data = [])
    {
        try {
            $calendar = new \mgCRM2\Models\GoogleModel(["id" => $id]);
            return $calendar->update($data);
        } catch (\Google_Exception $ex) {
            return $exc->getMessage();
        }
    }
    public function getSynchronizationFollowUp($followupId)
    {
        $table = $this->getModel()->getTable();
        $synchronizations = \Illuminate\Database\Capsule\Manager::table($table)->where($table . ".followup_id", "LIKE", $followupId)->get();
        $count = count($synchronizations);
        return ["data" => $synchronizations, "count" => $count];
    }
    public function isSynchonization()
    {
        $config = \Illuminate\Database\Capsule\Manager::table("crm_settings")->where("crm_settings.name", "=", "followups_synch_provider")->get();
        if(count($config) === 0) {
            return false;
        }
        return $this->addProviders($config[0]->value);
    }
    protected function addProviders($element)
    {
        $string = ltrim(rtrim($element, "]"), "[");
        if($string == "") {
            return false;
        }
        $array = explode("|X|", str_replace("},{", "}|X|{", $string));
        foreach ($array as $data) {
            $item = json_decode($data);
            $this->providers[$item->id] = $item;
        }
        return true;
    }
}

?>