<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Repository pattern for Records Statuses
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class FieldStatuses extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\FieldStatus";
    }
    public function massUpdate(array $list)
    {
        $statuses = $this->model->all();
        foreach ($statuses as $status) {
            if(array_get($list, $status->id . ".id") == $status->id) {
                $fill = array_get($list, $status->id);
                array_forget($fill, "id");
                $status->fill($fill);
                $status->save();
            }
        }
        return true;
    }
    public function getActive()
    {
        return $this->model->where("active", "=", 1)->orderBy("order", "asc")->get();
    }
    public function getWithCounter($adminID)
    {
        $return = $this->getModel()->orderBy("order", "ASC")->get();
        foreach ($return as &$r) {
            $r->resourcesCount = $r->countRecordsForAdmin($adminID);
        }
        return $return->toArray();
    }
    public function generateSummaryWithCounters(array $data = [])
    {
        $return = $this->getModel()->orderBy("order", "ASC")->get();
        $requestedAdmin = array_get($data, "admin_id", NULL);
        $requestedAdmin = \mgCRM2\Models\Validators\Common::isNumber($requestedAdmin) ? $requestedAdmin : NULL;
        if(array_get($data, "type_id", false) !== false) {
            $type_id = array_get($data, "type_id", false);
        } else {
            $type_id = 0;
        }
        $requestedCampaign = array_get($data, "campaign", NULL);
        $requestedCampaign = \mgCRM2\Models\Validators\Common::isNumber($requestedCampaign) ? $requestedCampaign : NULL;
        foreach ($return as &$r) {
            $r->resourcesCount = $r->countRecordsFor($type_id, $requestedAdmin, $requestedCampaign);
        }
        return $return->toArray();
    }
    public function reorder(array $newOrder)
    {
        if(empty($newOrder)) {
            $this->app->response->setStatus(404);
            throw new \Exception("Wrong order parameters provided");
        }
        $groups = $this->model->all();
        foreach ($groups as $group) {
            $group->order = array_get($newOrder, $group->id, 0);
            $group->save();
        }
        return true;
    }
}

?>