<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Fields
 * as repository pattern
 */
class Fields extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Field";
    }
    public function reorder(array $newOrder)
    {
        if(empty($newOrder)) {
            throw new \Exception("Wrong order parameters provided");
        }
        $fields = $this->model->all();
        foreach ($fields as $field) {
            $order = array_get($newOrder, $field->id . ".order", 0);
            $groupID = array_get($newOrder, $field->id . ".group", NULL);
            $field->order = $order;
            if(is_numeric($groupID) && $groupID !== NULL && intval($field->group_id) != $groupID) {
                $group = \mgCRM2\Models\FieldGroup::find($groupID);
                if(!$group) {
                    throw new \Exception("Could not find Field Group with ID " . $groupID);
                }
                $field->group()->associate($group);
            }
            $field->save();
        }
        return true;
    }
    public function updateSingleParamInModel($id, $data)
    {
        $model = $this->find($id);
        if(!$model) {
            throw new \Exception("Couldnt find group with id " . $id);
        }
        if(!$model->updateSingleParam($data)) {
            throw new \Exception("Something went wrong");
        }
        return $model;
    }
    public function createAndAssignToResource(\mgCRM2\Models\Resource &$resource, array $data = [])
    {
        $fields = \mgCRM2\Models\Field::activeFields()->withValidators()->get();
        $fieldsData = [];
        $errors = [];
        foreach ($fields as $field) {
            try {
                $fieldsData[] = $field->createNewData($resource, array_get($data, $field->id, []));
            } catch (\Exception $ex) {
                $errors[] = $e->getMessage();
            }
        }
        return !empty($errors) ? $errors : false;
    }
    public function addFieldValidator($id, $data)
    {
        $parsed = ["field_id" => $id, "type" => array_get($data, "type", NULL), "value" => array_get($data, "value", NULL), "error" => array_get($data, "error", NULL)];
        $new = new \mgCRM2\Models\FieldValidatorConfig();
        $new->create($parsed);
        return $new;
    }
}

?>