<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Files
 * as repository pattern
 */
class Files extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\File";
    }
    public function addFileForResource($resourceId, $file, $gotData)
    {
        $movedFile = \mgCRM2\Helpers\ManageFiles::moveUploadedFileForResource($resourceId, $file);
        $data = [];
        $data = array_add($data, "resource_id", intval($resourceId));
        $data = array_add($data, "admin_id", \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id);
        $data = array_add($data, "file_name", array_get($movedFile, "oryginal", ""));
        $data = array_add($data, "path_name", array_get($movedFile, "name", ""));
        $data = array_add($data, "description", array_get($gotData, "description", ""));
        $new = $this->model->create($data);
        $new->save();
        return $new;
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "updated_at");
        if($orderBy == "file_size") {
            $orderBy = "fileSize";
        }
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $description = array_get($data, "params.search.predicateObject.description", false);
        $admin_id = array_get($data, "params.search.predicateObject.admin_id", false);
        if($orderBy == "admin") {
            $orderBy = "admin_id";
        } elseif($orderBy == "type") {
            $orderBy = "type_id";
        }
        $queryTotal = \mgCRM2\Models\File::whereResource($resourceID);
        $query = $this->getModel()->whereResource($resourceID)->joinAdminRelevant()->take($limit)->offset($ofset);
        if($orderBy != "fileSize") {
            $query = $query->orderBy($orderBy, $orderDesc);
        }
        if(!empty($description) && $description !== false) {
            $query = $query->withDescriptionOrName($description);
            $queryTotal = $queryTotal->withDescriptionOrName($description);
        }
        if(!empty($admin_id) && $admin_id !== false) {
            $query = $query->where("admin_id", "=", $admin_id);
            $queryTotal = $queryTotal->where("admin_id", "=", $admin_id);
        }
        $results = $query->get();
        $count = $queryTotal->count();
        $parsed = [];
        foreach ($results as $r) {
            if($r->verifyFile()) {
                $tmp = $r->toArray();
                $tmp = array_add($tmp, "file_size", $r->fileSize);
                $tmp = array_add($tmp, "file_size_without_format", $r->fileSizeWithoutFormat);
                $parsed[] = $tmp;
            }
        }
        if($orderBy == "fileSize") {
            $orderDesc = $orderDesc == "ASC" ? true : false;
            usort($parsed, function ($a, $b) use($a) {
                if($a["file_size_without_format"] === $b["file_size_without_format"]) {
                    return 0;
                }
                if($orderDesc) {
                    return $b["file_size_without_format"] < $a["file_size_without_format"] ? -1 : 1;
                }
                return $a["file_size_without_format"] < $b["file_size_without_format"] ? -1 : 1;
            });
        }
        $return = ["data" => $parsed, "total" => $count];
        return $return;
    }
    public function getFile($id, $fileId)
    {
        $file = $this->getModel()->find($fileId);
        if(is_null($file)) {
            throw new \Exception("File not found");
        }
        if(file_exists($file->fileFullPath)) {
            header("Content-Description: File Transfer");
            header("Content-Type: application/octet-stream");
            header("Content-Disposition: attachment; filename=\"" . $file->file_name . "\"");
            header("Expires: 0");
            header("Cache-Control: must-revalidate");
            header("Pragma: public");
            header("Content-Length: " . filesize($file->fileFullPath));
            readfile($file->fileFullPath);
            exit;
        }
        throw new \Exception("File not found");
    }
    public function deleteFile($resourceId, $fileID)
    {
        $file = $this->getModel()->find($fileID);
        if(is_null($file)) {
            throw new \Exception(sprintf("Couldn't find File #%s for Resource %s", $fileID, $resourceId));
        }
        return $file->dropFile();
    }
}

?>