<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Files
 * as repository pattern
 */
class Labels extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Label";
    }
    public function addLabel($formData)
    {
        $data = [];
        $data = array_add($data, "name", array_get($formData, "name", ""));
        $data = array_add($data, "color", array_get($formData, "color", ""));
        $order = $this->getModel()->orderBy("order", "desc")->first()->order;
        $data = array_add($data, "order", $order && 0 < $order ? $order + 1 : 0);
        $new = $this->getModel()->create($data);
        $new->save();
        return $new;
    }
    public function updateLabel($id, $formData)
    {
        $label = $this->getModel()->where("id", $id)->first();
        if(is_null($label)) {
            throw new \Exception(sprintf("Couldn't find Label #%s", $id));
        }
        $label->fill($formData);
        $label->save();
        return true;
    }
    public function updateOrder($postData = [])
    {
        $oldList = [];
        foreach (array_get($postData, "updateLabels", []) as $labelId) {
            $oldList[$labelId] = array_map(function ($resourceLabel) {
                return $resourceLabel["client_id"] . "id";
            }, \mgCRM2\Models\ResourceLabel::where("label_id", $labelId)->get()->toArray());
            \mgCRM2\Models\ResourceLabel::where("label_id", $labelId)->delete();
        }
        foreach (array_get($postData, "newOrder", []) as $newOrder) {
            if($newOrder["id"] != 0) {
                foreach (array_get($postData, "updateLabels", []) as $labelId) {
                    if($labelId == $newOrder["id"]) {
                        foreach ($newOrder["resources"] as $number => $resource) {
                            if(0 >= \mgCRM2\Models\ResourceLabel::where("client_id", "LIKE", $resource)->where("label_id", "LIKE", $newOrder["id"])->count()) {
                                \mgCRM2\Models\ResourceLabel::create(["client_id" => $resource, "order" => $number, "label_id" => $newOrder["id"]]);
                                if(in_array($resource . "id", $oldList[$newOrder["id"]], true) === false) {
                                    foreach ($oldList as $searchLabelsId => $data) {
                                        if(in_array($resource . "id", $data, true)) {
                                            $oldId = $searchLabelsId;
                                            $from = \mgCRM2\Models\Label::where("id", $oldId)->first();
                                            $to = \mgCRM2\Models\Label::where("id", $labelId)->first();
                                            \mgCRM2\Models\Resource::where("id", $resource)->first()->addLog("move_labels", ["from" => $oldId ? " #" . $oldId . " " : "", "namefrom" => $from->name ? $from->name : "empty", "to" => $labelId ? " #" . $labelId . " " : "", "nameto" => $to->name ? $to->name : "empty"]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }
    public function getClientLabels($id)
    {
        $clientLabelModel = new \mgCRM2\Models\ResourceLabel();
        $clientLabels = $clientLabelModel->where("client_id", "=", $id)->get()->toArray();
        $labels = [];
        foreach ($clientLabels as $cl) {
            $labels[] = $cl["label_id"];
        }
        return $labels;
    }
    public function getLabelsWithClient()
    {
        $returnList = [];
        $withoutLabelClient = \mgCRM2\Models\Resource::leftJoin("crm_labels_clients", function ($join) {
            $join->on("crm_labels_clients.client_id", "LIKE", "crm_resources.id");
        })->whereNotNull("crm_resources.name")->whereNull("crm_labels_clients.client_id")->select("crm_resources.id", "crm_resources.name", "crm_resources.lastname", "crm_resources.short_description", "email")->get()->toArray();
        $returnList[] = ["id" => 0, "name" => \mgCRM2\Services\Language::translate("board.client.list"), "count" => count($withoutLabelClient), "recources" => $withoutLabelClient];
        if($labelsMap = \mgCRM2\Models\Setting::where("name", "labels_map")->where("admin_id", 0)->first()->value) {
            $withLabelClient = \mgCRM2\Models\Label::whereIn("crm_labels.id", $labelsMap)->with("recources")->orderBy("crm_labels.order", "asc")->get()->toArray();
            foreach ($withLabelClient as &$labels) {
                $labels["count"] = count($labels["recources"]);
            }
            $returnList = array_merge($returnList, $withLabelClient);
        }
        if(!isset($labelsMap)) {
            $labelsMap = [];
        }
        $labelSelect = \mgCRM2\Models\Label::whereNotIn("crm_labels.id", $labelsMap)->orderBy("crm_labels.order", "asc")->get()->toArray();
        $returnList = \mgCRM2\Helpers\LabelHelper::addLabelColor($returnList);
        $labelSelect = \mgCRM2\Helpers\LabelHelper::addLabelColor($labelSelect);
        return ["labelData" => $returnList, "labelSelect" => $labelSelect];
    }
    public function reorder($newOrder)
    {
        if(empty($newOrder)) {
            throw new \Exception("Wrong order parameters provided");
        }
        foreach ($newOrder as $labelId => $order) {
            \mgCRM2\Models\Label::where("id", "LIKE", $labelId)->update(["order" => $order]);
        }
        return true;
    }
    public function parseForTable(array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "order");
        $orderDesc = array_get($data, "params.sort.reverse", true) === false ? "DESC" : "ASC";
        $name = array_get($data, "params.search.predicateObject.name", false);
        $color = array_get($data, "params.search.predicateObject.color", false);
        $count = $this->getModel()->count();
        $query = $this->getModel()->take($limit)->orderBy($orderBy, $orderDesc)->offset($ofset);
        if(!empty($name) && $name !== false) {
            $query = $query->where("name", $name);
        }
        if(!empty($color) && $color !== false) {
            $query = $query->where("color", $color);
        }
        $results = \mgCRM2\Helpers\LabelHelper::addLabelColor($query->get()->toArray());
        $return = ["data" => $results, "total" => $count];
        return $return;
    }
    public function getLabel($id)
    {
        $label = $this->getModel()->find($id);
        if(is_null($label)) {
            throw new \Exception("Label not found");
        }
        return $label->toArray();
    }
    public function deleteLabel($id)
    {
        $label = $this->getModel()->find($id);
        if(is_null($label)) {
            throw new \Exception(sprintf("Couldn't find Label #%s", $id));
        }
        \mgCRM2\Models\ResourceLabel::where("label_id", $id)->delete();
        return $label->delete();
    }
}

?>