<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Logs
 * as repository pattern
 */
class Logs extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Log";
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $message = array_get($data, "params.search.predicateObject.message", false);
        $date = array_get($data, "params.search.predicateObject.date", false);
        $admin_id = array_get($data, "params.search.predicateObject.admin_id", false);
        $event = array_get($data, "params.search.predicateObject.event", false);
        $queryTotal = \mgCRM2\Models\Log::withResource($resourceID);
        $query = $this->getModel()->withAdmin()->withResource($resourceID)->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset);
        if(!empty($message) && $message !== false) {
            $query = $query->withMessage($message);
            $queryTotal = $query->withMessage($message);
        }
        if(!empty($date) && $date !== false) {
            $query = $query->whereDate($date);
            $queryTotal = $query->whereDate($date);
        }
        if(!empty($event) && $event !== false) {
            $query = $query->whereEvent($event);
            $queryTotal = $query->whereEvent($event);
        }
        if($admin_id !== false && is_numeric($admin_id)) {
            $query = $query->whereAdmin($admin_id);
            $queryTotal = $query->whereAdmin($admin_id);
        }
        $results = $query->get();
        $count = $queryTotal->count();
        $return = ["data" => $results->toArray(), "total" => $count];
        return $return;
    }
    public function parseForDashboardTable($data = [])
    {
        $alcRoles = \mgCRM2\Services\ACL::getInstance()->getCurrentAdminRules();
        if(isset($alcRoles["resources"]["not_mine"]) && !$alcRoles["resources"]["not_mine"] || !isset($alcRoles["resources"]["not_mine"])) {
            $adminId = array_get($data, "admin", NULL);
        }
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", []);
        $searchGlobal = array_pull($search, "\$", false);
        $sDate = array_get($data, "params.search.predicateObject.date", false);
        $sName = array_get($data, "params.search.predicateObject.lead_name", false);
        $sEvent = array_get($data, "params.search.predicateObject.event", false);
        $sMessage = array_get($data, "params.search.predicateObject.message", false);
        $sAdmin = array_get($data, "params.search.predicateObject.admin_id", false);
        $orders = ["date" => "crm_logs.date", "lead_name" => "crm_resources.lastname", "event" => "crm_logs.event", "message" => "crm_logs.message"];
        $query = $this->getModel()->withAdmin()->select(["crm_logs.*", "crm_resources.name", "crm_resources_types.icon", \Illuminate\Database\Capsule\Manager::raw("REPLACE(LOWER(`crm_resources_types`.`name`),\" \",\"_\") as `code`")])->resource()->leftJoin("crm_resources", "crm_resources.id", "=", "crm_logs.resource_id")->leftJoin("crm_resources_types", "crm_resources.type_id", "=", "crm_resources_types.id");
        if(isset($adminId)) {
            $query = $query->where("crm_logs.admin_id", "=", $adminId);
        } elseif(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($sAdmin) && $sAdmin !== false) {
            $query = $query->where("crm_logs.admin_id", "=", $sAdmin);
        } elseif($sAdmin != "") {
            if($sAdmin === 0) {
                $query = $query->whereNull("crm_logs.admin_id");
            } else {
                $query = $query->where("crm_logs.admin_id", "=", \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->id);
            }
        }
        if(!empty($sMessage)) {
            $query = $query->withMessage($sMessage);
        }
        if(!empty($sDate)) {
            $query = $query->whereDate($sDate);
        }
        if(!empty($sEvent)) {
            $query = $query->whereEvent($sEvent);
        }
        if(!empty($sName)) {
            $query = $query->where("crm_resources.name", "LIKE", "%" . $sName . "%")->orWhere("crm_resources.lastname", "LIKE", "%" . $sName . "%");
        }
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query = $query->where(function ($query) use($query) {
                $query->orWhere("crm_logs.event", "LIKE", "%" . $searchGlobal . "%")->orWhere("crm_resources.name", "LIKE", "%" . $searchGlobal . "%")->orWhere("crm_resources.lastname", "LIKE", "%" . $searchGlobal . "%")->orWhere("crm_logs.message", "LIKE", "%" . $searchGlobal . "%");
                if(preg_match("/^([0-9 :-]+)\$/", $searchGlobal)) {
                    $query->orWhere("crm_logs.date", "LIKE", "%" . $searchGlobal . "%");
                }
            });
        }
        $total = $query->count();
        $results = $query->orderBy($orders[$orderBy], $orderDesc)->take($limit)->offset($ofset)->get();
        $now = \Carbon\Carbon::now();
        $resultsArray = $results->toArray();
        foreach ($results as $k => $r) {
            $resultsArray[$k]["date"] = \Carbon\Carbon::parse($r->date)->diffForHumans();
        }
        $alc = \mgCRM2\Services\ACL::getInstance();
        $removeIds = [];
        foreach ($resultsArray as $key => $value) {
            if(!$alc->hasAccess("leads." . $value["code"])) {
                $removeIds[] = $key;
            }
        }
        foreach ($removeIds as $key) {
            unset($resultsArray[$key]);
        }
        $return = ["data" => $resultsArray, "total" => $total - count($removeIds)];
        return $return;
    }
}

?>